/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.network.grid;

import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.container.GridContainer;
import com.refinedmods.refinedstorage.tile.grid.WirelessFluidGrid;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class WirelessFluidGridSettingsUpdateMessage {
    private final int sortingDirection;
    private final int sortingType;
    private final int searchBoxMode;
    private final int size;
    private final int tabSelected;
    private final int tabPage;

    public WirelessFluidGridSettingsUpdateMessage(int sortingDirection, int sortingType, int searchBoxMode, int size, int tabSelected, int tabPage) {
        this.sortingDirection = sortingDirection;
        this.sortingType = sortingType;
        this.searchBoxMode = searchBoxMode;
        this.size = size;
        this.tabSelected = tabSelected;
        this.tabPage = tabPage;
    }

    public static WirelessFluidGridSettingsUpdateMessage decode(PacketBuffer buf) {
        return new WirelessFluidGridSettingsUpdateMessage(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void encode(WirelessFluidGridSettingsUpdateMessage message, PacketBuffer buf) {
        buf.writeInt(message.sortingDirection);
        buf.writeInt(message.sortingType);
        buf.writeInt(message.searchBoxMode);
        buf.writeInt(message.size);
        buf.writeInt(message.tabSelected);
        buf.writeInt(message.tabPage);
    }

    public static void handle(WirelessFluidGridSettingsUpdateMessage message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = ctx.get().getSender();
        if (player != null) {
            ctx.get().enqueueWork(() -> WirelessFluidGridSettingsUpdateMessage.lambda$handle$0((PlayerEntity)player, message));
        }
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$handle$0(PlayerEntity player, WirelessFluidGridSettingsUpdateMessage message) {
        IGrid grid;
        if (player.field_71070_bA instanceof GridContainer && (grid = ((GridContainer)player.field_71070_bA).getGrid()) instanceof WirelessFluidGrid) {
            ItemStack stack = ((WirelessFluidGrid)grid).getStack();
            if (IGrid.isValidSortingDirection(message.sortingDirection)) {
                stack.func_77978_p().func_74768_a("SortingDirection", message.sortingDirection);
            }
            if (IGrid.isValidSortingType(message.sortingType)) {
                stack.func_77978_p().func_74768_a("SortingType", message.sortingType);
            }
            if (IGrid.isValidSearchBoxMode(message.searchBoxMode)) {
                stack.func_77978_p().func_74768_a("SearchBoxMode", message.searchBoxMode);
            }
            if (IGrid.isValidSize(message.size)) {
                stack.func_77978_p().func_74768_a("Size", message.size);
            }
            stack.func_77978_p().func_74768_a("TabSelected", message.tabSelected);
            stack.func_77978_p().func_74768_a("TabPage", message.tabPage);
        }
    }
}

