/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.tile;

import com.refinedmods.refinedstorage.RSTiles;
import com.refinedmods.refinedstorage.apiimpl.network.node.DetectorNetworkNode;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.DetectorScreen;
import com.refinedmods.refinedstorage.tile.NetworkNodeTile;
import com.refinedmods.refinedstorage.tile.config.IComparable;
import com.refinedmods.refinedstorage.tile.config.IType;
import com.refinedmods.refinedstorage.tile.data.TileDataParameter;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DetectorTile
extends NetworkNodeTile<DetectorNetworkNode> {
    public static final TileDataParameter<Integer, DetectorTile> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer, DetectorTile> TYPE = IType.createParameter();
    public static final TileDataParameter<Integer, DetectorTile> MODE = new TileDataParameter<Integer, DetectorTile>(DataSerializers.field_187192_b, 0, t -> ((DetectorNetworkNode)t.getNode()).getMode(), (t, v) -> {
        if (v == 0 || v == 1 || v == 2) {
            ((DetectorNetworkNode)t.getNode()).setMode((int)v);
            ((DetectorNetworkNode)t.getNode()).markDirty();
        }
    });
    public static final TileDataParameter<Integer, DetectorTile> AMOUNT = new TileDataParameter<Integer, DetectorTile>(DataSerializers.field_187192_b, 0, t -> ((DetectorNetworkNode)t.getNode()).getAmount(), (t, v) -> {
        ((DetectorNetworkNode)t.getNode()).setAmount((int)v);
        ((DetectorNetworkNode)t.getNode()).markDirty();
    }, (initial, value) -> BaseScreen.executeLater(DetectorScreen.class, detectorScreen -> detectorScreen.updateAmountField((int)value)));
    private static final String NBT_POWERED = "Powered";

    public DetectorTile() {
        super(RSTiles.DETECTOR);
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(TYPE);
        this.dataManager.addWatchedParameter(MODE);
        this.dataManager.addWatchedParameter(AMOUNT);
    }

    @Override
    public void readUpdate(CompoundNBT tag) {
        ((DetectorNetworkNode)this.getNode()).setPowered(tag.func_74767_n(NBT_POWERED));
        super.readUpdate(tag);
    }

    @Override
    public CompoundNBT writeUpdate(CompoundNBT tag) {
        super.writeUpdate(tag);
        tag.func_74757_a(NBT_POWERED, ((DetectorNetworkNode)this.getNode()).isPowered());
        return tag;
    }

    @Override
    @Nonnull
    public DetectorNetworkNode createNode(World world, BlockPos pos) {
        return new DetectorNetworkNode(world, pos);
    }
}

