/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.tile.data;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.network.tiledata.TileDataParameterUpdateMessage;
import com.refinedmods.refinedstorage.tile.data.TileDataParameter;
import com.refinedmods.refinedstorage.tile.data.TileDataWatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.tileentity.TileEntity;

public class TileDataManager {
    private static int lastId = 0;
    private static final Map<Integer, TileDataParameter> REGISTRY = new HashMap<Integer, TileDataParameter>();
    private final TileEntity tile;
    private final List<TileDataParameter> parameters = new ArrayList<TileDataParameter>();
    private final List<TileDataParameter> watchedParameters = new ArrayList<TileDataParameter>();
    private final List<TileDataWatcher> watchers = new CopyOnWriteArrayList<TileDataWatcher>();

    public TileDataManager(TileEntity tile) {
        this.tile = tile;
    }

    public TileEntity getTile() {
        return this.tile;
    }

    public void addParameter(TileDataParameter parameter) {
        this.parameters.add(parameter);
    }

    public List<TileDataParameter> getParameters() {
        return this.parameters;
    }

    public void addWatchedParameter(TileDataParameter parameter) {
        this.addParameter(parameter);
        this.watchedParameters.add(parameter);
    }

    public List<TileDataParameter> getWatchedParameters() {
        return this.watchedParameters;
    }

    public void addWatcher(TileDataWatcher listener) {
        this.watchers.add(listener);
    }

    public void removeWatcher(TileDataWatcher listener) {
        this.watchers.remove(listener);
    }

    public void sendParameterToWatchers(TileDataParameter parameter) {
        this.watchers.forEach(l -> l.sendParameter(false, parameter));
    }

    public static void registerParameter(TileDataParameter parameter) {
        parameter.setId(lastId);
        REGISTRY.put(lastId++, parameter);
    }

    public static TileDataParameter getParameter(int id) {
        return REGISTRY.get(id);
    }

    public static void setParameter(TileDataParameter parameter, Object value) {
        RS.NETWORK_HANDLER.sendToServer(new TileDataParameterUpdateMessage(parameter, value));
    }
}

