/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.tile.data;

import com.refinedmods.refinedstorage.tile.data.TileDataParameterClientListener;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tileentity.TileEntity;

public class TileDataParameter<T, E extends TileEntity> {
    private int id;
    private final IDataSerializer<T> serializer;
    private final Function<E, T> valueProducer;
    @Nullable
    private final BiConsumer<E, T> valueConsumer;
    @Nullable
    private final TileDataParameterClientListener<T> listener;
    private T value;

    public TileDataParameter(IDataSerializer<T> serializer, T defaultValue, Function<E, T> producer) {
        this(serializer, defaultValue, producer, null);
    }

    public TileDataParameter(IDataSerializer<T> serializer, T defaultValue, Function<E, T> producer, @Nullable BiConsumer<E, T> consumer) {
        this(serializer, defaultValue, producer, consumer, null);
    }

    public TileDataParameter(IDataSerializer<T> serializer, T defaultValue, Function<E, T> producer, @Nullable BiConsumer<E, T> consumer, @Nullable TileDataParameterClientListener<T> listener) {
        this.value = defaultValue;
        this.serializer = serializer;
        this.valueProducer = producer;
        this.valueConsumer = consumer;
        this.listener = listener;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public IDataSerializer<T> getSerializer() {
        return this.serializer;
    }

    public Function<E, T> getValueProducer() {
        return this.valueProducer;
    }

    @Nullable
    public BiConsumer<E, T> getValueConsumer() {
        return this.valueConsumer;
    }

    public void setValue(boolean initial, T value) {
        this.value = value;
        if (this.listener != null) {
            this.listener.onChanged(initial, value);
        }
    }

    public T getValue() {
        return this.value;
    }
}

