/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.render.Styles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.gui.GuiUtils;

public final class RenderUtils {
    private RenderUtils() {
    }

    public static String shorten(String text, int length) {
        if (text.length() > length) {
            text = text.substring(0, length) + "...";
        }
        return text;
    }

    public static int getOffsetOnScale(int pos, float scale) {
        float multiplier = (float)pos / scale;
        return (int)multiplier;
    }

    public static void addCombinedItemsToTooltip(List<ITextComponent> tooltip, boolean displayAmount, List<ItemStack> stacks) {
        HashSet<Integer> combinedIndices = new HashSet<Integer>();
        for (int i = 0; i < stacks.size(); ++i) {
            if (stacks.get(i).func_190926_b() || combinedIndices.contains(i)) continue;
            ItemStack stack = stacks.get(i);
            IFormattableTextComponent data = stack.func_200301_q().func_230531_f_();
            int amount = stack.func_190916_E();
            for (int j = i + 1; j < stacks.size(); ++j) {
                if (!API.instance().getComparer().isEqual(stack, stacks.get(j))) continue;
                amount += stacks.get(j).func_190916_E();
                combinedIndices.add(j);
            }
            if (displayAmount) {
                data = new StringTextComponent(amount + "x ").func_230529_a_((ITextComponent)data);
            }
            tooltip.add((ITextComponent)data.func_230530_a_(Styles.GRAY));
        }
    }

    public static void addCombinedFluidsToTooltip(List<ITextComponent> tooltip, boolean displayMb, List<FluidStack> stacks) {
        HashSet<Integer> combinedIndices = new HashSet<Integer>();
        for (int i = 0; i < stacks.size(); ++i) {
            if (stacks.get(i).isEmpty() || combinedIndices.contains(i)) continue;
            FluidStack stack = stacks.get(i);
            IFormattableTextComponent data = stack.getDisplayName().func_230531_f_();
            int amount = stack.getAmount();
            for (int j = i + 1; j < stacks.size(); ++j) {
                if (!API.instance().getComparer().isEqual(stack, stacks.get(j), 1)) continue;
                amount += stacks.get(j).getAmount();
                combinedIndices.add(j);
            }
            if (displayMb) {
                data = new StringTextComponent(API.instance().getQuantityFormatter().formatInBucketForm(amount) + " ").func_230529_a_((ITextComponent)data);
            }
            tooltip.add((ITextComponent)data.func_230530_a_(Styles.GRAY));
        }
    }

    public static void drawTooltipWithSmallText(MatrixStack matrixStack, List<? extends ITextProperties> textLines, List<String> smallTextLines, boolean showSmallText, @Nonnull ItemStack stack, int mouseX, int mouseY, int screenWidth, int screenHeight, FontRenderer fontRenderer) {
        float textScale;
        int maxTextWidth = -1;
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        float f = textScale = Minecraft.func_71410_x().func_211821_e() ? 1.0f : 0.7f;
        if (!textLines.isEmpty()) {
            int n;
            RenderTooltipEvent.Pre event = new RenderTooltipEvent.Pre(stack, textLines, matrixStack, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, font);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            mouseX = event.getX();
            mouseY = event.getY();
            screenWidth = event.getScreenWidth();
            screenHeight = event.getScreenHeight();
            maxTextWidth = event.getMaxWidth();
            font = event.getFontRenderer();
            RenderSystem.disableRescaleNormal();
            RenderSystem.disableDepthTest();
            int tooltipTextWidth = 0;
            for (ITextProperties iTextProperties : textLines) {
                int textLineWidth = font.func_78256_a(iTextProperties.getString());
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            if (showSmallText) {
                for (String string : smallTextLines) {
                    int size = (int)((float)font.func_78256_a(string) * textScale);
                    if (size <= tooltipTextWidth) continue;
                    tooltipTextWidth = size;
                }
            }
            boolean needsWrap = false;
            boolean bl = true;
            int tooltipX = mouseX + 12;
            if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
                needsWrap = true;
            }
            if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList<? extends ITextProperties> wrappedTextLines = new ArrayList<ITextProperties>();
                for (int i = 0; i < textLines.size(); ++i) {
                    ITextProperties textLine = textLines.get(i);
                    List wrappedLine = font.func_238420_b_().func_238362_b_(textLine, tooltipTextWidth, Style.field_240709_b_);
                    if (i == 0) {
                        n = wrappedLine.size();
                    }
                    for (ITextProperties line : wrappedLine) {
                        int lineWidth = font.func_78256_a(line.getString());
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add((ITextProperties)line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
            }
            int tooltipY = mouseY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > n) {
                    tooltipHeight += 2;
                }
            }
            if (showSmallText) {
                tooltipHeight += smallTextLines.size() * 10;
            }
            if (tooltipY < 4) {
                tooltipY = 4;
            } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 4;
            }
            int zLevel = 500;
            int backgroundColor = -267386864;
            int borderColorStart = 0x505000FF;
            int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
            RenderTooltipEvent.Color colorEvent = new RenderTooltipEvent.Color(stack, textLines, matrixStack, tooltipX, tooltipY, font, backgroundColor, borderColorStart, borderColorEnd);
            MinecraftForge.EVENT_BUS.post((Event)colorEvent);
            backgroundColor = colorEvent.getBackground();
            borderColorStart = colorEvent.getBorderStart();
            borderColorEnd = colorEvent.getBorderEnd();
            Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
            GuiUtils.drawGradientRect((Matrix4f)matrix, (int)500, (int)(tooltipX - 3), (int)(tooltipY - 4), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((Matrix4f)matrix, (int)500, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 4), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((Matrix4f)matrix, (int)500, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((Matrix4f)matrix, (int)500, (int)(tooltipX - 4), (int)(tooltipY - 3), (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((Matrix4f)matrix, (int)500, (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 4), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((Matrix4f)matrix, (int)500, (int)(tooltipX - 3), (int)(tooltipY - 3 + 1), (int)(tooltipX - 3 + 1), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
            GuiUtils.drawGradientRect((Matrix4f)matrix, (int)500, (int)(tooltipX + tooltipTextWidth + 2), (int)(tooltipY - 3 + 1), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
            GuiUtils.drawGradientRect((Matrix4f)matrix, (int)500, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3 + 1), (int)borderColorStart, (int)borderColorStart);
            GuiUtils.drawGradientRect((Matrix4f)matrix, (int)500, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 2), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)borderColorEnd, (int)borderColorEnd);
            MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostBackground(stack, textLines, matrixStack, tooltipX, tooltipY, font, tooltipTextWidth, tooltipHeight));
            IRenderTypeBuffer.Impl renderType = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            MatrixStack textStack = new MatrixStack();
            textStack.func_227861_a_(0.0, 0.0, 500.0);
            Matrix4f textLocation = textStack.func_227866_c_().func_227870_a_();
            int tooltipTop = tooltipY;
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                ITextProperties line = textLines.get(lineNumber);
                if (line != null) {
                    font.func_238416_a_(LanguageMap.func_74808_a().func_241870_a(line), (float)tooltipX, (float)tooltipY, -1, true, textLocation, (IRenderTypeBuffer)renderType, false, 0, 0xF000F0);
                }
                if (lineNumber + 1 == n) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            renderType.func_228461_a_();
            MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostText(stack, textLines, matrixStack, tooltipX, tooltipTop, font, tooltipTextWidth, tooltipHeight));
            if (showSmallText) {
                int y = tooltipTop + tooltipHeight - 6;
                for (int i = smallTextLines.size() - 1; i >= 0; --i) {
                    RenderSystem.enableAlphaTest();
                    MatrixStack smallTextStack = new MatrixStack();
                    smallTextStack.func_227861_a_(0.0, 0.0, 500.0);
                    smallTextStack.func_227862_a_(textScale, textScale, 1.0f);
                    IRenderTypeBuffer.Impl renderTypeBuffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
                    font.func_228079_a_(TextFormatting.GRAY + smallTextLines.get(i), (float)RenderUtils.getOffsetOnScale(tooltipX, textScale), (float)RenderUtils.getOffsetOnScale(y - (Minecraft.func_71410_x().func_211821_e() ? 2 : 0), textScale), -1, true, smallTextStack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)renderTypeBuffer, false, 0, 0xF000F0);
                    renderTypeBuffer.func_228461_a_();
                    y -= 9;
                }
            }
            RenderSystem.enableDepthTest();
            RenderSystem.enableRescaleNormal();
        }
    }

    public static List<ITextComponent> getTooltipFromItem(ItemStack stack) {
        Minecraft minecraft = Minecraft.func_71410_x();
        return stack.func_82840_a((PlayerEntity)minecraft.field_71439_g, (ITooltipFlag)(minecraft.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
    }

    public static boolean inBounds(int x, int y, int w, int h, double ox, double oy) {
        return ox >= (double)x && ox <= (double)(x + w) && oy >= (double)y && oy <= (double)(y + h);
    }
}

