/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.platform;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import me.shedaniel.architectury.Architectury;
import me.shedaniel.architectury.platform.Mod;
import me.shedaniel.architectury.platform.forge.PlatformImpl;
import me.shedaniel.architectury.utils.Env;
import net.minecraft.util.SharedConstants;
import net.minecraftforge.api.distmarker.Dist;
import org.jetbrains.annotations.ApiStatus;

public final class Platform {
    private static int simpleLoaderCache = -1;

    private Platform() {
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0")
    public static String getModLoader() {
        return Architectury.getModLoader();
    }

    public static boolean isFabric() {
        Platform.updateLoaderCache();
        return simpleLoaderCache == 0;
    }

    public static boolean isForge() {
        Platform.updateLoaderCache();
        return simpleLoaderCache == 1;
    }

    private static void updateLoaderCache() {
        if (simpleLoaderCache != -1) {
            return;
        }
        switch (Platform.getModLoader()) {
            case "fabric": {
                simpleLoaderCache = 0;
                return;
            }
            case "forge": {
                simpleLoaderCache = 1;
                return;
            }
        }
    }

    public static String getMinecraftVersion() {
        return SharedConstants.func_215069_a().getId();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getGameFolder() {
        return PlatformImpl.getGameFolder();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getConfigFolder() {
        return PlatformImpl.getConfigFolder();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Env getEnvironment() {
        return PlatformImpl.getEnvironment();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Dist getEnv() {
        return PlatformImpl.getEnv();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isModLoaded(String id) {
        return PlatformImpl.isModLoaded(id);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Mod getMod(String id) {
        return PlatformImpl.getMod(id);
    }

    public static Optional<Mod> getOptionalMod(String id) {
        try {
            return Optional.of(Platform.getMod(id));
        }
        catch (NullPointerException e) {
            return Optional.empty();
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Collection<Mod> getMods() {
        return PlatformImpl.getMods();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Collection<String> getModIds() {
        return PlatformImpl.getModIds();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isDevelopmentEnvironment() {
        return PlatformImpl.isDevelopmentEnvironment();
    }
}

