/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.utils;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;

public class ModIdentification {
    private static final Map<String, Info> CONTAINER_CACHE = Maps.newHashMap();
    private static final Info MC_MOD_INFO = new Info("minecraft", "Minecraft");

    public static Info getModInfo(String namespace) {
        return CONTAINER_CACHE.computeIfAbsent(namespace, s -> ModList.get().getMods().stream().filter(c -> c.getModId().equals(s)).map(c -> new Info(c.getModId(), c.getDisplayName())).findFirst().orElse(new Info((String)s, (String)s)));
    }

    public static Info getModInfo(ResourceLocation id) {
        return ModIdentification.getModInfo(id.func_110624_b());
    }

    public static Info getModInfo(Block block) {
        return ModIdentification.getModInfo(block.getRegistryName());
    }

    public static Info getModInfo(ItemStack stack) {
        return ModIdentification.getModInfo(stack.func_77973_b().getCreatorModId(stack));
    }

    public static Info getModInfo(Item item) {
        return ModIdentification.getModInfo(new ItemStack((IItemProvider)item));
    }

    public static Info getModInfo(Entity entity) {
        ResourceLocation registryName = entity.func_200600_R().getRegistryName();
        return registryName == null ? MC_MOD_INFO : ModIdentification.getModInfo(registryName);
    }

    static {
        CONTAINER_CACHE.put(MC_MOD_INFO.getId(), MC_MOD_INFO);
    }

    public static class Info {
        private final String id;
        private final String name;

        public Info(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

