/*
 * Decompiled with CFR 0.152.
 */
package com.mcwbridges.kikoz.objects;

import com.mcwbridges.kikoz.objects.BridgePart;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class BridgeBase
extends Block
implements IWaterLoggable {
    private static final EnumProperty<BridgePart> PART = EnumProperty.func_177709_a((String)"part", BridgePart.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    private static final VoxelShape X_AXIS_AABB = Stream.of(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape Z_AXIS_AABB = Stream.of(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    public static ToIntFunction<BlockState> lightLevel = BlockState2 -> 5;

    public static ToIntFunction<BlockState> setLightLevel(int lightValue) {
        return state -> {
            if (BlockStateProperties.field_208190_q == LIT) {
                return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q) != false ? lightValue : 0;
            }
            return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q) != false ? lightValue : 15;
        };
    }

    public BridgeBase(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false))).func_206870_a(PART, (Comparable)((Object)BridgePart.MIDDLE))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld world, BlockPos pos, BlockPos newPos) {
        return this.getStateforBridge(state, world, pos, (Direction)state.func_177229_b((Property)FACING));
    }

    private boolean BridgeDirection(IWorld world, BlockPos source, Direction direction, Direction facing) {
        BlockState state = world.func_180495_p(source.func_177972_a(direction));
        if (state.func_177230_c() == this) {
            Direction bridgedir = (Direction)state.func_177229_b((Property)FACING);
            return bridgedir.equals((Object)facing);
        }
        return false;
    }

    private BlockState getStateforBridge(BlockState state, IWorld world, BlockPos pos, Direction dir) {
        boolean front = this.BridgeDirection(world, pos, dir.func_176735_f(), dir);
        boolean back = this.BridgeDirection(world, pos, dir.func_176746_e(), dir);
        if (front && back) {
            return (BlockState)state.func_206870_a(PART, (Comparable)((Object)BridgePart.MIDDLE));
        }
        if (front) {
            return (BlockState)state.func_206870_a(PART, (Comparable)((Object)BridgePart.END));
        }
        if (back) {
            return (BlockState)state.func_206870_a(PART, (Comparable)((Object)BridgePart.END2));
        }
        return (BlockState)state.func_206870_a(PART, (Comparable)((Object)BridgePart.MIDDLE));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader blockReader, BlockPos pos, ISelectionContext selectionContext) {
        BridgePart part = (BridgePart)((Object)state.func_177229_b(PART));
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case WEST: {
                if (part == BridgePart.MIDDLE) {
                    return X_AXIS_AABB;
                }
                return X_AXIS_AABB;
            }
            case EAST: {
                if (part == BridgePart.MIDDLE) {
                    return X_AXIS_AABB;
                }
                return X_AXIS_AABB;
            }
            case NORTH: {
                if (part == BridgePart.MIDDLE) {
                    return Z_AXIS_AABB;
                }
                return Z_AXIS_AABB;
            }
            case SOUTH: {
                if (part == BridgePart.MIDDLE) {
                    return Z_AXIS_AABB;
                }
                return Z_AXIS_AABB;
            }
        }
        return null;
    }

    public static ResourceLocation location(String name) {
        return new ResourceLocation("mcwbridges", name);
    }

    public ToolType getHarvestTool(BlockState state) {
        if (this.field_149764_J == Material.field_151575_d || this.field_149764_J == Material.field_215713_z) {
            return ToolType.AXE;
        }
        return ToolType.PICKAXE;
    }

    public void onBroken(World worldIn, BlockPos pos) {
        worldIn.func_217379_c(1029, pos, 0);
    }

    public int getHarvestLevel(BlockState state) {
        return 1;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        super.func_176208_a(world, pos, state, player);
        Boolean i = (Boolean)state.func_177229_b((Property)LIT);
        if (i.booleanValue()) {
            BridgeBase.dropTorch(world, pos);
        }
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public static void dropTorch(World world, BlockPos pos) {
        BridgeBase.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)Items.field_221657_bQ, 1));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(handIn);
        Item item = itemstack.func_77973_b();
        Boolean i = (Boolean)state.func_177229_b((Property)LIT);
        if (i.booleanValue()) {
            state = (BlockState)state.func_235896_a_((Property)LIT);
            worldIn.func_180501_a(pos, state, 2);
            BridgeBase.dropTorch(worldIn, pos);
        }
        if (!i.booleanValue() && item != Items.field_221657_bQ) {
            return ActionResultType.PASS;
        }
        if (item == Items.field_221657_bQ && !i.booleanValue()) {
            state = (BlockState)state.func_235896_a_((Property)LIT);
            worldIn.func_180501_a(pos, state, 2);
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
        }
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        Boolean i = (Boolean)state.func_177229_b((Property)LIT);
        if (i.booleanValue()) {
            return 14;
        }
        return 0;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public float func_220080_a(BlockState p_220080_1_, IBlockReader p_220080_2_, BlockPos p_220080_3_) {
        return 1.0f;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176746_e());
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, WATERLOGGED, PART, LIT});
    }
}

