/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.crafting;

import com.blakebr0.cucumber.config.ModConfigs;
import com.google.common.base.Stopwatch;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TagMapper
implements IResourceManagerReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogManager.getLogger((String)"Cucumber Library");
    private static final Map<String, String> TAG_TO_ITEM_MAP = new HashMap<String, String>();

    public void func_195410_a(IResourceManager manager) {
        TagMapper.reloadTagMappings();
    }

    @SubscribeEvent
    public void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadTagMappings() {
        Stopwatch stopwatch;
        block4: {
            File file;
            block5: {
                stopwatch = Stopwatch.createStarted();
                File dir = FMLPaths.CONFIGDIR.get().toFile();
                TAG_TO_ITEM_MAP.clear();
                if (!dir.exists() || !dir.isDirectory()) break block4;
                file = FMLPaths.CONFIGDIR.get().resolve("cucumber-tags.json").toFile();
                if (!file.exists() || !file.isFile()) break block5;
                FileReader reader = null;
                try {
                    JsonParser parser = new JsonParser();
                    reader = new FileReader(file);
                    JsonObject json = parser.parse((Reader)reader).getAsJsonObject();
                    json.entrySet().stream().filter(e -> {
                        String value = ((JsonElement)e.getValue()).getAsString();
                        return !"__comment".equalsIgnoreCase((String)e.getKey()) && !value.isEmpty() && !"null".equalsIgnoreCase(value);
                    }).forEach(entry -> {
                        String tag = (String)entry.getKey();
                        String item = ((JsonElement)entry.getValue()).getAsString();
                        TAG_TO_ITEM_MAP.put(tag, item);
                    });
                    reader.close();
                }
                catch (Exception e2) {
                    try {
                        LOGGER.error("An error occurred while reading cucumber-tags.json", (Throwable)e2);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(reader);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Reader)reader);
                    break block4;
                }
                IOUtils.closeQuietly((Reader)reader);
                break block4;
            }
            TagMapper.generateNewConfig(file);
        }
        stopwatch.stop();
        LOGGER.info("Loaded cucumber-tags.json in {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Item getItemForTag(String tagId) {
        block9: {
            if (TAG_TO_ITEM_MAP.containsKey(tagId)) {
                String id = TAG_TO_ITEM_MAP.get(tagId);
                return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id));
            }
            File file = FMLPaths.CONFIGDIR.get().resolve("cucumber-tags.json").toFile();
            if (!file.exists()) {
                TagMapper.generateNewConfig(file);
            }
            if (!file.isFile()) break block9;
            JsonObject json = null;
            FileReader reader = null;
            try {
                JsonParser parser = new JsonParser();
                reader = new FileReader(file);
                json = parser.parse((Reader)reader).getAsJsonObject();
            }
            catch (Exception e) {
                try {
                    LOGGER.error("An error occurred while reading cucumber-tags.json", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)reader);
            }
            IOUtils.closeQuietly((Reader)reader);
            if (json != null) {
                if (json.has(tagId)) {
                    String itemId = json.get(tagId).getAsString();
                    if (itemId.isEmpty() || "null".equalsIgnoreCase(itemId)) {
                        return TagMapper.addTagToFile(tagId, json, file);
                    }
                    TAG_TO_ITEM_MAP.put(tagId, itemId);
                    return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId));
                }
                return TagMapper.addTagToFile(tagId, json, file);
            }
        }
        return Items.field_190931_a;
    }

    private static Item addTagToFile(String tagId, JsonObject json, File file) {
        List mods = (List)ModConfigs.MOD_TAG_PRIORITIES.get();
        ITag tag = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(new ResourceLocation(tagId));
        Item item = tag == null ? Items.field_190931_a : tag.func_230236_b_().stream().min((item1, item2) -> {
            int index2;
            int index1 = item1.getRegistryName() != null ? mods.indexOf(item1.getRegistryName().func_110624_b()) : -1;
            int n = index2 = item2.getRegistryName() != null ? mods.indexOf(item2.getRegistryName().func_110624_b()) : -1;
            return index1 > index2 ? 1 : (index1 == -1 ? 0 : -1);
        }).orElse(Items.field_190931_a);
        String itemId = "null";
        if (item.getRegistryName() != null && item != Items.field_190931_a) {
            itemId = item.getRegistryName().toString();
        }
        json.addProperty(tagId, itemId);
        TAG_TO_ITEM_MAP.put(tagId, itemId);
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson((JsonElement)json, (Appendable)writer);
        }
        catch (IOException e) {
            LOGGER.error("An error occurred while writing to cucumber-tags.json", (Throwable)e);
        }
        return item;
    }

    private static void generateNewConfig(File file) {
        try (FileWriter writer = new FileWriter(file);){
            JsonObject object = new JsonObject();
            object.addProperty("__comment", "Instructions: https://mods.blakebr0.com/docs/cucumber/tags-config");
            GSON.toJson((JsonElement)object, (Appendable)writer);
        }
        catch (IOException e) {
            LOGGER.error("An error occurred while creating cucumber-tags.json", (Throwable)e);
        }
    }
}

