/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.energy;

import com.blakebr0.cucumber.helper.NBTHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.EnergyStorage;

public class ItemEnergyStorage
extends EnergyStorage {
    private final ItemStack container;

    public ItemEnergyStorage(ItemStack stack, int capacity) {
        super(capacity);
        this.container = stack;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energy = NBTHelper.getInt(this.container, "Energy");
        int energyReceived = Math.min(this.capacity - energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            NBTHelper.setInt(this.container, "Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int energy = NBTHelper.getInt(this.container, "Energy");
        int energyExtracted = Math.min(energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            NBTHelper.setInt(this.container, "Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return NBTHelper.getInt(this.container, "Energy");
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }
}

