/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.helper;

import com.blakebr0.cucumber.helper.NBTHelper;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;

public final class StackHelper {
    public static ItemStack withSize(ItemStack stack, int size, boolean container) {
        if (size <= 0) {
            if (container && stack.hasContainerItem()) {
                return stack.getContainerItem();
            }
            return ItemStack.field_190927_a;
        }
        stack = stack.func_77946_l();
        stack.func_190920_e(size);
        return stack;
    }

    public static ItemStack grow(ItemStack stack, int amount) {
        return StackHelper.withSize(stack, stack.func_190916_E() + amount, false);
    }

    public static ItemStack shrink(ItemStack stack, int amount, boolean container) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        return StackHelper.withSize(stack, stack.func_190916_E() - amount, container);
    }

    public static boolean areItemsEqual(ItemStack stack1, ItemStack stack2) {
        return !stack1.func_190926_b() && !stack2.func_190926_b() && stack1.func_77969_a(stack2);
    }

    public static boolean areStacksEqual(ItemStack stack1, ItemStack stack2) {
        return StackHelper.areItemsEqual(stack1, stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean canCombineStacks(ItemStack stack1, ItemStack stack2) {
        if (!stack1.func_190926_b() && stack2.func_190926_b()) {
            return true;
        }
        return StackHelper.areStacksEqual(stack1, stack2) && stack1.func_190916_E() + stack2.func_190916_E() <= stack1.func_77976_d();
    }

    public static ItemStack combineStacks(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_190926_b()) {
            return stack2.func_77946_l();
        }
        return StackHelper.grow(stack1, stack2.func_190916_E());
    }

    public static boolean compareTags(ItemStack stack1, ItemStack stack2) {
        if (!stack1.func_77942_o()) {
            return true;
        }
        if (stack1.func_77942_o() && !stack2.func_77942_o()) {
            return false;
        }
        Set stack1Keys = NBTHelper.getTagCompound(stack1).func_150296_c();
        Set stack2Keys = NBTHelper.getTagCompound(stack2).func_150296_c();
        for (String key : stack1Keys) {
            if (stack2Keys.contains(key)) {
                if (NBTUtil.func_181123_a((INBT)NBTHelper.getTag(stack1, key), (INBT)NBTHelper.getTag(stack2, key), (boolean)true)) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

