/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.entity;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import mekanism.additions.common.registries.AdditionsEntityTypes;
import mekanism.additions.common.registries.AdditionsItems;
import mekanism.additions.common.registries.AdditionsSounds;
import mekanism.api.text.EnumColor;
import mekanism.common.registration.impl.EntityTypeRegistryObject;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityBalloon
extends Entity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Byte> IS_LATCHED = EntityDataManager.func_187226_a(EntityBalloon.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> LATCHED_X = EntityDataManager.func_187226_a(EntityBalloon.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LATCHED_Y = EntityDataManager.func_187226_a(EntityBalloon.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LATCHED_Z = EntityDataManager.func_187226_a(EntityBalloon.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LATCHED_ID = EntityDataManager.func_187226_a(EntityBalloon.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final double OFFSET = -0.275;
    private EnumColor color = EnumColor.DARK_BLUE;
    private BlockPos latched;
    public LivingEntity latchedEntity;
    private boolean hasCachedEntity;
    private UUID cachedEntityUUID;

    public EntityBalloon(EntityType<EntityBalloon> type, World world) {
        super(type, world);
        this.field_70158_ak = true;
        this.field_70156_m = true;
        this.func_70107_b(this.func_226277_ct_() + 0.5, this.func_226278_cu_() + 3.0, this.func_226281_cx_() + 0.5);
        this.func_213293_j(this.func_213322_ci().func_82615_a(), 0.04, this.func_213322_ci().func_82616_c());
        this.field_70180_af.func_187214_a(IS_LATCHED, (Object)0);
        this.field_70180_af.func_187214_a(LATCHED_X, (Object)0);
        this.field_70180_af.func_187214_a(LATCHED_Y, (Object)0);
        this.field_70180_af.func_187214_a(LATCHED_Z, (Object)0);
        this.field_70180_af.func_187214_a(LATCHED_ID, (Object)-1);
    }

    private EntityBalloon(EntityTypeRegistryObject<EntityBalloon> type, World world) {
        this((EntityType<EntityBalloon>)type.getEntityType(), world);
    }

    public EntityBalloon(World world, double x, double y, double z, EnumColor c) {
        this(AdditionsEntityTypes.BALLOON, world);
        this.func_70107_b(x + 0.5, y + 3.0, z + 0.5);
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        this.color = c;
    }

    public EntityBalloon(LivingEntity entity, EnumColor c) {
        this(AdditionsEntityTypes.BALLOON, entity.field_70170_p);
        this.latchedEntity = entity;
        float height = this.latchedEntity.func_213305_a((Pose)this.latchedEntity.func_213283_Z()).field_220316_b;
        this.func_70107_b(this.latchedEntity.func_226277_ct_(), this.latchedEntity.func_226278_cu_() + (double)height + (double)1.7f, this.latchedEntity.func_226281_cx_());
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        this.color = c;
        this.field_70180_af.func_187227_b(IS_LATCHED, (Object)2);
        this.field_70180_af.func_187227_b(LATCHED_ID, (Object)entity.func_145782_y());
    }

    public EntityBalloon(World world, BlockPos pos, EnumColor c) {
        this(AdditionsEntityTypes.BALLOON, world);
        this.latched = pos;
        this.func_70107_b((float)this.latched.func_177958_n() + 0.5f, (float)this.latched.func_177956_o() + 1.8f, (float)this.latched.func_177952_p() + 0.5f);
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        this.color = c;
        this.field_70180_af.func_187227_b(IS_LATCHED, (Object)1);
        this.field_70180_af.func_187227_b(LATCHED_X, (Object)this.latched.func_177958_n());
        this.field_70180_af.func_187227_b(LATCHED_Y, (Object)this.latched.func_177956_o());
        this.field_70180_af.func_187227_b(LATCHED_Z, (Object)this.latched.func_177952_p());
    }

    public EnumColor getColor() {
        return this.color;
    }

    public void func_70071_h_() {
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        if (this.func_226278_cu_() >= (double)this.field_70170_p.func_217301_I()) {
            this.pop();
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            this.latched = (Byte)this.field_70180_af.func_187225_a(IS_LATCHED) == 1 ? new BlockPos(((Integer)this.field_70180_af.func_187225_a(LATCHED_X)).intValue(), ((Integer)this.field_70180_af.func_187225_a(LATCHED_Y)).intValue(), ((Integer)this.field_70180_af.func_187225_a(LATCHED_Z)).intValue()) : null;
            this.latchedEntity = (Byte)this.field_70180_af.func_187225_a(IS_LATCHED) == 2 ? (LivingEntity)this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(LATCHED_ID)).intValue()) : null;
        } else {
            if (this.hasCachedEntity) {
                Entity entity;
                if (this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.cachedEntityUUID)) instanceof LivingEntity) {
                    this.latchedEntity = (LivingEntity)entity;
                }
                this.cachedEntityUUID = null;
                this.hasCachedEntity = false;
            }
            if (this.field_70173_aa == 1) {
                byte isLatched = this.latched != null ? (byte)1 : (this.latchedEntity != null ? (byte)2 : 0);
                this.field_70180_af.func_187227_b(IS_LATCHED, (Object)isLatched);
                this.field_70180_af.func_187227_b(LATCHED_X, (Object)(this.latched == null ? 0 : this.latched.func_177958_n()));
                this.field_70180_af.func_187227_b(LATCHED_Y, (Object)(this.latched == null ? 0 : this.latched.func_177956_o()));
                this.field_70180_af.func_187227_b(LATCHED_Z, (Object)(this.latched == null ? 0 : this.latched.func_177952_p()));
                this.field_70180_af.func_187227_b(LATCHED_ID, (Object)(this.latchedEntity == null ? -1 : this.latchedEntity.func_145782_y()));
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            Optional blockState;
            if (this.latched != null && (blockState = WorldUtils.getBlockState((IBlockReader)this.field_70170_p, (BlockPos)this.latched)).isPresent() && ((BlockState)blockState.get()).isAir((IBlockReader)this.field_70170_p, this.latched)) {
                this.latched = null;
                this.field_70180_af.func_187227_b(IS_LATCHED, (Object)0);
            }
            if (!(this.latchedEntity == null || !(this.latchedEntity.func_110143_aJ() <= 0.0f) && this.latchedEntity.func_70089_S() && this.field_70170_p.func_72863_F().func_217204_a((Entity)this.latchedEntity))) {
                this.latchedEntity = null;
                this.field_70180_af.func_187227_b(IS_LATCHED, (Object)0);
            }
        }
        if (!this.isLatched()) {
            Vector3d motion = this.func_213322_ci();
            this.func_213293_j(motion.func_82615_a(), Math.min(motion.func_82617_b() * (double)1.02f, (double)0.2f), motion.func_82616_c());
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            motion = this.func_213322_ci();
            motion = motion.func_216372_d(0.98, 0.0, 0.98);
            if (this.field_70122_E) {
                motion = motion.func_216372_d(0.7, 0.0, 0.7);
            }
            if (motion.func_82617_b() == 0.0) {
                motion = new Vector3d(motion.func_82615_a(), 0.04, motion.func_82616_c());
            }
            this.func_213317_d(motion);
        } else if (this.latched != null) {
            this.func_213293_j(0.0, 0.0, 0.0);
        } else if (this.latchedEntity != null && this.latchedEntity.func_110143_aJ() > 0.0f) {
            int floor = this.getFloor(this.latchedEntity);
            Vector3d motion = this.latchedEntity.func_213322_ci();
            if (this.latchedEntity.func_226278_cu_() - (double)(floor + 1) < -0.1) {
                this.latchedEntity.func_213293_j(motion.func_82615_a(), Math.max(0.04, motion.func_82617_b() * 1.015), motion.func_82616_c());
            } else if (this.latchedEntity.func_226278_cu_() - (double)(floor + 1) > 0.1) {
                this.latchedEntity.func_213293_j(motion.func_82615_a(), Math.min(-0.04, motion.func_82617_b() * 1.015), motion.func_82616_c());
            } else {
                this.latchedEntity.func_213293_j(motion.func_82615_a(), 0.0, motion.func_82616_c());
            }
            this.func_70107_b(this.latchedEntity.func_226277_ct_(), this.latchedEntity.func_226278_cu_() + this.getAddedHeight(), this.latchedEntity.func_226281_cx_());
        }
    }

    public double getAddedHeight() {
        return (double)this.latchedEntity.func_213305_a((Pose)this.latchedEntity.func_213283_Z()).field_220316_b + 0.8;
    }

    private int getFloor(LivingEntity entity) {
        BlockPos pos;
        BlockPos posi = pos = new BlockPos(entity.func_213303_ch());
        while (posi.func_177956_o() > 0) {
            if (posi.func_177956_o() < this.field_70170_p.func_217301_I() && !this.field_70170_p.func_175623_d(posi)) {
                return posi.func_177956_o() + 1 + (entity instanceof PlayerEntity ? 1 : 0);
            }
            posi = posi.func_177977_b();
        }
        return -1;
    }

    private void pop() {
        this.func_184185_a(AdditionsSounds.POP.getSoundEvent(), 1.0f, 1.0f);
        if (!this.field_70170_p.field_72995_K) {
            RedstoneParticleData redstoneParticleData = new RedstoneParticleData(this.color.getColor(0), this.color.getColor(1), this.color.getColor(2), 1.0f);
            for (int i = 0; i < 10; ++i) {
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)redstoneParticleData, this.func_226277_ct_() + 0.6 * (double)this.field_70146_Z.nextFloat() - 0.3, this.func_226278_cu_() + 0.6 * (double)this.field_70146_Z.nextFloat() - 0.3, this.func_226281_cx_() + 0.6 * (double)this.field_70146_Z.nextFloat() - 0.3, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        this.func_70106_y();
    }

    public boolean func_70104_M() {
        return this.latched == null;
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    protected boolean func_225502_at_() {
        return false;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(@Nonnull CompoundNBT nbtTags) {
        NBTUtils.setEnumIfPresent((CompoundNBT)nbtTags, (String)"color", EnumColor::byIndexStatic, color -> {
            this.color = color;
        });
        NBTUtils.setBlockPosIfPresent((CompoundNBT)nbtTags, (String)"latched", pos -> {
            this.latched = pos;
        });
        NBTUtils.setUUIDIfPresent((CompoundNBT)nbtTags, (String)"owner", uuid -> {
            this.hasCachedEntity = true;
            this.cachedEntityUUID = uuid;
        });
    }

    protected void func_213281_b(@Nonnull CompoundNBT nbtTags) {
        nbtTags.func_74768_a("color", this.color.ordinal());
        if (this.latched != null) {
            nbtTags.func_218657_a("latched", (INBT)NBTUtil.func_186859_a((BlockPos)this.latched));
        }
        if (this.latchedEntity != null) {
            nbtTags.func_186854_a("owner", this.latchedEntity.func_110124_au());
        }
    }

    public boolean func_85031_j(@Nonnull Entity entity) {
        this.pop();
        return true;
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer data) {
        data.writeDouble(this.func_226277_ct_());
        data.writeDouble(this.func_226278_cu_());
        data.writeDouble(this.func_226281_cx_());
        data.func_179249_a((Enum)this.color);
        if (this.latched != null) {
            data.writeByte(1);
            data.func_179255_a(this.latched);
        } else if (this.latchedEntity != null) {
            data.writeByte(2);
            data.func_150787_b(this.latchedEntity.func_145782_y());
        } else {
            data.writeByte(0);
        }
    }

    public void readSpawnData(PacketBuffer data) {
        this.func_70107_b(data.readDouble(), data.readDouble(), data.readDouble());
        this.color = (EnumColor)data.func_179257_a(EnumColor.class);
        byte type = data.readByte();
        if (type == 1) {
            this.latched = data.func_179259_c();
        } else if (type == 2) {
            this.latchedEntity = (LivingEntity)this.field_70170_p.func_73045_a(data.func_150792_a());
        } else {
            this.latched = null;
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.latchedEntity != null) {
            this.latchedEntity.field_70160_al = false;
        }
    }

    public boolean func_70112_a(double dist) {
        return dist <= 64.0;
    }

    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    public boolean func_70097_a(@Nonnull DamageSource dmgSource, float damage) {
        if (this.func_180431_b(dmgSource)) {
            return false;
        }
        this.func_70018_K();
        if (dmgSource != DamageSource.field_76376_m && dmgSource != DamageSource.field_76369_e && dmgSource != DamageSource.field_76379_h) {
            this.pop();
            return true;
        }
        return false;
    }

    public boolean isLatched() {
        if (this.field_70170_p.field_72995_K) {
            return (Byte)this.field_70180_af.func_187225_a(IS_LATCHED) > 0;
        }
        return this.latched != null || this.latchedEntity != null;
    }

    public boolean isLatchedToEntity() {
        return (Byte)this.field_70180_af.func_187225_a(IS_LATCHED) == 2 && this.latchedEntity != null;
    }

    protected float func_213316_a(@Nonnull Pose pose, @Nonnull EntitySize size) {
        return (float)((double)size.field_220316_b - -0.275);
    }

    @Nonnull
    protected AxisAlignedBB func_213321_d(@Nonnull Pose pose) {
        return this.getBoundingBox(this.func_213305_a(pose), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
    }

    public void func_70107_b(double x, double y, double z) {
        this.func_226288_n_(x, y, z);
        if (this.isAddedToWorld() && !this.field_70170_p.field_72995_K && this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_217464_b((Entity)this);
        }
        this.func_174826_a(this.getBoundingBox(this.func_213305_a(Pose.STANDING), x, y, z));
    }

    private AxisAlignedBB getBoundingBox(EntitySize size, double x, double y, double z) {
        float f = size.field_220315_a / 2.0f;
        double posY = y - -0.275;
        return new AxisAlignedBB(new Vector3d(x - (double)f, posY, z - (double)f), new Vector3d(x + (double)f, posY + (double)size.field_220316_b, z + (double)f));
    }

    public void func_213323_x_() {
    }

    public void func_174829_m() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        this.func_226288_n_((axisalignedbb.field_72340_a + axisalignedbb.field_72336_d) / 2.0, axisalignedbb.field_72338_b + -0.275, (axisalignedbb.field_72339_c + axisalignedbb.field_72334_f) / 2.0);
        if (this.isAddedToWorld() && !this.field_70170_p.field_72995_K && this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_217464_b((Entity)this);
        }
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        switch (this.color) {
            case BLACK: {
                return AdditionsItems.BLACK_BALLOON.getItemStack();
            }
            case DARK_BLUE: {
                return AdditionsItems.BLUE_BALLOON.getItemStack();
            }
            case DARK_GREEN: {
                return AdditionsItems.GREEN_BALLOON.getItemStack();
            }
            case DARK_AQUA: {
                return AdditionsItems.CYAN_BALLOON.getItemStack();
            }
            case PURPLE: {
                return AdditionsItems.PURPLE_BALLOON.getItemStack();
            }
            case ORANGE: {
                return AdditionsItems.ORANGE_BALLOON.getItemStack();
            }
            case GRAY: {
                return AdditionsItems.LIGHT_GRAY_BALLOON.getItemStack();
            }
            case DARK_GRAY: {
                return AdditionsItems.GRAY_BALLOON.getItemStack();
            }
            case INDIGO: {
                return AdditionsItems.LIGHT_BLUE_BALLOON.getItemStack();
            }
            case BRIGHT_GREEN: {
                return AdditionsItems.LIME_BALLOON.getItemStack();
            }
            case RED: {
                return AdditionsItems.RED_BALLOON.getItemStack();
            }
            case PINK: {
                return AdditionsItems.MAGENTA_BALLOON.getItemStack();
            }
            case YELLOW: {
                return AdditionsItems.YELLOW_BALLOON.getItemStack();
            }
            case WHITE: {
                return AdditionsItems.WHITE_BALLOON.getItemStack();
            }
            case BROWN: {
                return AdditionsItems.BROWN_BALLOON.getItemStack();
            }
            case BRIGHT_PINK: {
                return AdditionsItems.PINK_BALLOON.getItemStack();
            }
        }
        return super.getPickedResult(target);
    }
}

