/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world;

import biomesoplenty.common.world.layer.BOPShoreLayer;
import biomesoplenty.common.world.layer.LandLayer;
import biomesoplenty.common.world.layer.NetherBiomeLayer;
import biomesoplenty.common.world.layer.traits.LazyAreaLayerContextBOP;
import java.util.function.LongFunction;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.AddIslandLayer;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.LayerUtil;
import net.minecraft.world.gen.layer.SmoothLayer;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;

public class BOPNetherLayerUtil {
    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> createBiomeFactory(IAreaFactory<T> landFactory, LongFunction<C> contextFactory) {
        IAreaFactory biomeFactory = NetherBiomeLayer.INSTANCE.func_202823_a((IExtendedNoiseRandom)contextFactory.apply(200L));
        biomeFactory = LayerUtil.func_202829_a((long)1000L, (IAreaTransformer1)ZoomLayer.NORMAL, (IAreaFactory)biomeFactory, (int)2, contextFactory);
        return biomeFactory;
    }

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> createAreaFactories(LongFunction<C> contextFactory) {
        int biomeSize = 4;
        IAreaFactory landFactory = LandLayer.INSTANCE.func_202823_a((IExtendedNoiseRandom)contextFactory.apply(1L));
        IAreaFactory biomesFactory = BOPNetherLayerUtil.createBiomeFactory(landFactory, contextFactory);
        for (int i = 0; i < biomeSize; ++i) {
            biomesFactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000 + i), biomesFactory);
            if (i == 0) {
                biomesFactory = AddIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(3L), biomesFactory);
            }
            if (i != 1 && biomeSize != 1) continue;
            biomesFactory = BOPShoreLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L), biomesFactory);
        }
        biomesFactory = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L), biomesFactory);
        return biomesFactory;
    }

    public static Layer createGenLayers(long seed) {
        IAreaFactory factory = BOPNetherLayerUtil.createAreaFactories(seedModifier -> new LazyAreaLayerContextBOP(1, seed, seedModifier));
        return new Layer(factory);
    }
}

