/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature.tree;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.util.biome.GeneratorUtil;
import biomesoplenty.common.util.block.IBlockPosQuery;
import biomesoplenty.common.world.gen.feature.tree.TreeFeatureBase;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.IPlantable;

public class PalmTreeFeature
extends TreeFeatureBase {
    protected PalmTreeFeature(IBlockPosQuery placeOn, IBlockPosQuery replace, BlockState log, BlockState leaves, BlockState altLeaves, BlockState vine, BlockState hanging, BlockState trunkFruit, int minHeight, int maxHeight) {
        super(placeOn, replace, log, leaves, altLeaves, vine, hanging, trunkFruit, minHeight, maxHeight);
    }

    @Override
    protected boolean place(Set<BlockPos> changedLogs, Set<BlockPos> changedLeaves, IWorld world, Random random, BlockPos startPos, MutableBoundingBox boundingBox) {
        while (startPos.func_177956_o() > 1 && world.func_175623_d(startPos) || world.func_180495_p(startPos).func_185904_a() == Material.field_151584_j) {
            startPos = startPos.func_177977_b();
        }
        if (!this.placeOn.matches(world, startPos)) {
            return false;
        }
        int height = GeneratorUtil.nextIntBetween(random, this.minHeight, this.maxHeight);
        int leavesRadius = 2;
        int heightMinusTop = height - leavesRadius - 1;
        boolean slant = false;
        Direction direction = Direction.func_239631_a_((Random)random);
        if (direction == Direction.DOWN || direction == Direction.UP) {
            slant = false;
        }
        double baseSlant = (double)random.nextInt(35) / 100.0;
        double slantMultiplier = 1.3;
        if (height < 8) {
            return false;
        }
        BlockPos pos = startPos.func_177984_a();
        if (!this.checkSpace(world, pos, height, 1)) {
            return false;
        }
        double slantOffset = baseSlant;
        for (int step = 0; step <= heightMinusTop; ++step) {
            BlockPos offsetPos = pos.func_177981_b(step);
            if (slant) {
                offsetPos = pos.func_177981_b(step).func_177967_a(direction, (int)Math.floor(slantOffset));
            }
            if (step == heightMinusTop) {
                this.placeLog(world, offsetPos, changedLogs, boundingBox);
                this.generateLeavesTop(world, offsetPos, leavesRadius, changedLeaves, boundingBox);
                break;
            }
            this.placeLog(world, offsetPos, changedLogs, boundingBox);
            slantOffset *= slantMultiplier;
        }
        return true;
    }

    public boolean checkSpace(IWorld world, BlockPos pos, int height, int radius) {
        for (int y = 0; y <= height; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos1 = pos.func_177982_a(x, y, z);
                    if (pos1.func_177956_o() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateLeavesTop(IWorld world, BlockPos pos, int maxRadius, Set<BlockPos> changedLeaves, MutableBoundingBox boundingBox) {
        this.placeLeaves(world, pos.func_177982_a(2, -1, 0), changedLeaves, boundingBox);
        this.placeLeaves(world, pos.func_177982_a(-2, -1, 0), changedLeaves, boundingBox);
        this.placeLeaves(world, pos.func_177982_a(0, -1, 2), changedLeaves, boundingBox);
        this.placeLeaves(world, pos.func_177982_a(0, -1, -2), changedLeaves, boundingBox);
        this.placeLeaves(world, pos.func_177982_a(1, 0, 0), changedLeaves, boundingBox);
        this.placeLeaves(world, pos.func_177982_a(-1, 0, 0), changedLeaves, boundingBox);
        this.placeLeaves(world, pos.func_177982_a(0, 0, 1), changedLeaves, boundingBox);
        this.placeLeaves(world, pos.func_177982_a(0, 0, -1), changedLeaves, boundingBox);
        this.placeLeaves(world, pos.func_177982_a(2, 0, 2), changedLeaves, boundingBox);
        this.placeLeaves(world, pos.func_177982_a(-2, 0, -2), changedLeaves, boundingBox);
        this.placeLeaves(world, pos.func_177982_a(2, 0, -2), changedLeaves, boundingBox);
        this.placeLeaves(world, pos.func_177982_a(-2, 0, 2), changedLeaves, boundingBox);
        this.placeLeaves(world, pos.func_177982_a(1, 1, -1), changedLeaves, boundingBox);
        this.placeLeaves(world, pos.func_177982_a(-1, 1, 1), changedLeaves, boundingBox);
        this.placeLeaves(world, pos.func_177982_a(1, 1, 1), changedLeaves, boundingBox);
        this.placeLeaves(world, pos.func_177982_a(-1, 1, -1), changedLeaves, boundingBox);
        this.placeLeaves(world, pos.func_177982_a(0, 1, 0), changedLeaves, boundingBox);
        this.placeLeaves(world, pos.func_177982_a(2, 2, 0), changedLeaves, boundingBox);
        this.placeLeaves(world, pos.func_177982_a(-2, 2, 0), changedLeaves, boundingBox);
        this.placeLeaves(world, pos.func_177982_a(0, 2, 2), changedLeaves, boundingBox);
        this.placeLeaves(world, pos.func_177982_a(0, 2, -2), changedLeaves, boundingBox);
    }

    public static class Builder
    extends TreeFeatureBase.BuilderBase<Builder, PalmTreeFeature> {
        public Builder() {
            this.placeOn = (world, pos) -> {
                Block ground = world.func_180495_p(pos).func_177230_c();
                return world.func_180495_p(pos).canSustainPlant((IBlockReader)world, pos, Direction.UP, (IPlantable)((SaplingBlock)Blocks.field_196674_t)) || ground == BOPBlocks.white_sand || ground == Blocks.field_196611_F || ground == Blocks.field_150354_m;
            };
            this.minHeight = 10;
            this.maxHeight = 14;
            this.log = BOPBlocks.palm_log.func_176223_P();
            this.leaves = (BlockState)BOPBlocks.palm_leaves.func_176223_P().func_206870_a((Property)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true));
        }

        @Override
        public PalmTreeFeature create() {
            return new PalmTreeFeature(this.placeOn, this.replace, this.log, this.leaves, this.altLeaves, this.vine, this.hanging, this.trunkFruit, this.minHeight, this.maxHeight);
        }
    }
}

