/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import java.util.Random;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.Bookshelf;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ISidedInventoryProvider;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.WorkbenchContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class InventoryUtils {
    public static IItemHandler getInventory(World world, BlockPos pos, Direction side) {
        ISidedInventoryProvider inventoryProvider;
        ISidedInventory inventory;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null) {
            LazyOptional inventoryCap = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
            return (IItemHandler)inventoryCap.orElse((Object)EmptyHandler.INSTANCE);
        }
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof ISidedInventoryProvider && (inventory = (inventoryProvider = (ISidedInventoryProvider)state.func_177230_c()).func_219966_a(state, (IWorld)world, pos)) != null) {
            return new SidedInvWrapper(inventory, side);
        }
        return EmptyHandler.INSTANCE;
    }

    public static boolean hasInventory(World world, BlockPos pos, Direction side) {
        IItemHandler handler = InventoryUtils.getInventory(world, pos, side);
        return handler != null && handler != EmptyHandler.INSTANCE;
    }

    @Nullable
    public static Container getCraftingContainer(CraftingInventory craftingInv) {
        return craftingInv.field_70465_c;
    }

    @Nullable
    public static PlayerEntity getCraftingPlayer(IInventory inventory) {
        return InventoryUtils.getCraftingPlayer(inventory, null);
    }

    @Nullable
    public static PlayerEntity getCraftingPlayer(IInventory inventory, World world) {
        if (inventory instanceof PlayerInventory) {
            return ((PlayerInventory)inventory).field_70458_d;
        }
        if (inventory instanceof CraftingInventory) {
            Container container = InventoryUtils.getCraftingContainer((CraftingInventory)inventory);
            if (container instanceof WorkbenchContainer) {
                return ((WorkbenchContainer)container).field_192390_i;
            }
            if (container instanceof PlayerContainer) {
                return ((PlayerContainer)container).field_82862_h;
            }
        }
        return null;
    }

    public static NonNullList<ItemStack> keepDamageableItems(CraftingInventory inv, NonNullList<ItemStack> keptItems, boolean ignoreUnbreaking, int damageAmount) {
        for (int i = 0; i < keptItems.size(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!stack.func_77973_b().func_77645_m() && (!stack.func_77942_o() || !stack.func_77978_p().func_74767_n("Unbreakable"))) continue;
            PlayerEntity player = InventoryUtils.getCraftingPlayer((IInventory)inv);
            Random random = player != null ? player.func_70681_au() : Bookshelf.RANDOM;
            ItemStack retainedStack = stack.func_77946_l();
            if (ignoreUnbreaking) {
                if (retainedStack.func_77984_f()) {
                    retainedStack.func_196085_b(retainedStack.func_77952_i() + damageAmount);
                }
            } else {
                retainedStack.func_96631_a(damageAmount, random, player instanceof ServerPlayerEntity ? (ServerPlayerEntity)player : null);
            }
            keptItems.set(i, (Object)retainedStack);
        }
        return keptItems;
    }
}

