/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.init;

import com.blakebr0.cucumber.block.BaseBlock;
import com.blakebr0.cucumber.block.BaseGlassBlock;
import com.blakebr0.cucumber.block.BaseOreBlock;
import com.blakebr0.cucumber.block.BaseSlabBlock;
import com.blakebr0.cucumber.block.BaseStairsBlock;
import com.blakebr0.cucumber.block.BaseWallBlock;
import com.blakebr0.cucumber.item.BaseBlockItem;
import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.blakebr0.mysticalagriculture.block.EssenceFurnaceBlock;
import com.blakebr0.mysticalagriculture.block.GrowthAcceleratorBlock;
import com.blakebr0.mysticalagriculture.block.InferiumCropBlock;
import com.blakebr0.mysticalagriculture.block.InfusedFarmlandBlock;
import com.blakebr0.mysticalagriculture.block.InfusionAltarBlock;
import com.blakebr0.mysticalagriculture.block.InfusionPedestalBlock;
import com.blakebr0.mysticalagriculture.block.ReprocessorBlock;
import com.blakebr0.mysticalagriculture.block.SoulExtractorBlock;
import com.blakebr0.mysticalagriculture.block.TinkeringTableBlock;
import com.blakebr0.mysticalagriculture.block.WitherproofBlock;
import com.blakebr0.mysticalagriculture.block.WitherproofGlassBlock;
import com.blakebr0.mysticalagriculture.init.ModItems;
import com.blakebr0.mysticalagriculture.lib.ModCrops;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import com.blakebr0.mysticalagriculture.util.ReprocessorTier;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class ModBlocks {
    public static final Map<RegistryObject<Block>, Supplier<Block>> ENTRIES = new LinkedHashMap<RegistryObject<Block>, Supplier<Block>>();
    public static final RegistryObject<Block> PROSPERITY_BLOCK = ModBlocks.register("prosperity_block", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 4.0f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> INFERIUM_BLOCK = ModBlocks.register("inferium_block", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 4.0f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> PRUDENTIUM_BLOCK = ModBlocks.register("prudentium_block", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 4.0f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> TERTIUM_BLOCK = ModBlocks.register("tertium_block", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 4.0f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> IMPERIUM_BLOCK = ModBlocks.register("imperium_block", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 4.0f, 5.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> SUPREMIUM_BLOCK = ModBlocks.register("supremium_block", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 4.0f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> SOULIUM_BLOCK = ModBlocks.register("soulium_block", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 4.0f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> PROSPERITY_INGOT_BLOCK = ModBlocks.register("prosperity_ingot_block", () -> new BaseBlock(Material.field_151573_f, SoundType.field_185852_e, 5.0f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> INFERIUM_INGOT_BLOCK = ModBlocks.register("inferium_ingot_block", () -> new BaseBlock(Material.field_151573_f, SoundType.field_185852_e, 5.0f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> PRUDENTIUM_INGOT_BLOCK = ModBlocks.register("prudentium_ingot_block", () -> new BaseBlock(Material.field_151573_f, SoundType.field_185852_e, 5.0f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> TERTIUM_INGOT_BLOCK = ModBlocks.register("tertium_ingot_block", () -> new BaseBlock(Material.field_151573_f, SoundType.field_185852_e, 5.0f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> IMPERIUM_INGOT_BLOCK = ModBlocks.register("imperium_ingot_block", () -> new BaseBlock(Material.field_151573_f, SoundType.field_185852_e, 5.0f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> SUPREMIUM_INGOT_BLOCK = ModBlocks.register("supremium_ingot_block", () -> new BaseBlock(Material.field_151573_f, SoundType.field_185852_e, 5.0f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> SOULIUM_INGOT_BLOCK = ModBlocks.register("soulium_ingot_block", () -> new BaseBlock(Material.field_151573_f, SoundType.field_185852_e, 5.0f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> PROSPERITY_GEMSTONE_BLOCK = ModBlocks.register("prosperity_gemstone_block", () -> new BaseBlock(Material.field_151573_f, SoundType.field_185852_e, 5.0f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> INFERIUM_GEMSTONE_BLOCK = ModBlocks.register("inferium_gemstone_block", () -> new BaseBlock(Material.field_151573_f, SoundType.field_185852_e, 5.0f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> PRUDENTIUM_GEMSTONE_BLOCK = ModBlocks.register("prudentium_gemstone_block", () -> new BaseBlock(Material.field_151573_f, SoundType.field_185852_e, 5.0f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> TERTIUM_GEMSTONE_BLOCK = ModBlocks.register("tertium_gemstone_block", () -> new BaseBlock(Material.field_151573_f, SoundType.field_185852_e, 5.0f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> IMPERIUM_GEMSTONE_BLOCK = ModBlocks.register("imperium_gemstone_block", () -> new BaseBlock(Material.field_151573_f, SoundType.field_185852_e, 5.0f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> SUPREMIUM_GEMSTONE_BLOCK = ModBlocks.register("supremium_gemstone_block", () -> new BaseBlock(Material.field_151573_f, SoundType.field_185852_e, 5.0f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> SOULIUM_GEMSTONE_BLOCK = ModBlocks.register("soulium_gemstone_block", () -> new BaseBlock(Material.field_151573_f, SoundType.field_185852_e, 5.0f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> INFERIUM_FARMLAND = ModBlocks.register("inferium_farmland", () -> new InfusedFarmlandBlock(CropTier.ONE));
    public static final RegistryObject<Block> PRUDENTIUM_FARMLAND = ModBlocks.register("prudentium_farmland", () -> new InfusedFarmlandBlock(CropTier.TWO));
    public static final RegistryObject<Block> TERTIUM_FARMLAND = ModBlocks.register("tertium_farmland", () -> new InfusedFarmlandBlock(CropTier.THREE));
    public static final RegistryObject<Block> IMPERIUM_FARMLAND = ModBlocks.register("imperium_farmland", () -> new InfusedFarmlandBlock(CropTier.FOUR));
    public static final RegistryObject<Block> SUPREMIUM_FARMLAND = ModBlocks.register("supremium_farmland", () -> new InfusedFarmlandBlock(CropTier.FIVE));
    public static final RegistryObject<Block> INFERIUM_GROWTH_ACCELERATOR = ModBlocks.register("inferium_growth_accelerator", () -> new GrowthAcceleratorBlock(12, CropTier.ONE.getTextColor()));
    public static final RegistryObject<Block> PRUDENTIUM_GROWTH_ACCELERATOR = ModBlocks.register("prudentium_growth_accelerator", () -> new GrowthAcceleratorBlock(24, CropTier.TWO.getTextColor()));
    public static final RegistryObject<Block> TERTIUM_GROWTH_ACCELERATOR = ModBlocks.register("tertium_growth_accelerator", () -> new GrowthAcceleratorBlock(36, CropTier.THREE.getTextColor()));
    public static final RegistryObject<Block> IMPERIUM_GROWTH_ACCELERATOR = ModBlocks.register("imperium_growth_accelerator", () -> new GrowthAcceleratorBlock(48, CropTier.FOUR.getTextColor()));
    public static final RegistryObject<Block> SUPREMIUM_GROWTH_ACCELERATOR = ModBlocks.register("supremium_growth_accelerator", () -> new GrowthAcceleratorBlock(60, CropTier.FIVE.getTextColor()));
    public static final RegistryObject<Block> INFERIUM_FURNACE = ModBlocks.register("inferium_furnace", () -> new EssenceFurnaceBlock(EssenceFurnaceBlock.FurnaceTier.INFERIUM));
    public static final RegistryObject<Block> PRUDENTIUM_FURNACE = ModBlocks.register("prudentium_furnace", () -> new EssenceFurnaceBlock(EssenceFurnaceBlock.FurnaceTier.PRUDENTIUM));
    public static final RegistryObject<Block> TERTIUM_FURNACE = ModBlocks.register("tertium_furnace", () -> new EssenceFurnaceBlock(EssenceFurnaceBlock.FurnaceTier.TERTIUM));
    public static final RegistryObject<Block> IMPERIUM_FURNACE = ModBlocks.register("imperium_furnace", () -> new EssenceFurnaceBlock(EssenceFurnaceBlock.FurnaceTier.IMPERIUM));
    public static final RegistryObject<Block> SUPREMIUM_FURNACE = ModBlocks.register("supremium_furnace", () -> new EssenceFurnaceBlock(EssenceFurnaceBlock.FurnaceTier.SUPREMIUM));
    public static final RegistryObject<Block> PROSPERITY_ORE = ModBlocks.register("prosperity_ore", () -> new BaseOreBlock(Material.field_151576_e, SoundType.field_185851_d, 3.0f, 3.0f, 2, 5));
    public static final RegistryObject<Block> INFERIUM_ORE = ModBlocks.register("inferium_ore", () -> new BaseOreBlock(Material.field_151576_e, SoundType.field_185851_d, 3.0f, 3.0f, 2, 5));
    public static final RegistryObject<Block> SOULIUM_ORE = ModBlocks.register("soulium_ore", () -> new BaseOreBlock(Material.field_151576_e, SoundType.field_185851_d, 3.0f, 3.0f, 3, 7));
    public static final RegistryObject<Block> SOULSTONE = ModBlocks.register("soulstone", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 1.5f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> SOULSTONE_COBBLE = ModBlocks.register("soulstone_cobble", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 2.0f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> SOULSTONE_BRICKS = ModBlocks.register("soulstone_bricks", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 1.5f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> SOULSTONE_CRACKED_BRICKS = ModBlocks.register("soulstone_cracked_bricks", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 1.5f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> SOULSTONE_CHISELED_BRICKS = ModBlocks.register("soulstone_chiseled_bricks", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 1.5f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> SOULSTONE_SMOOTH = ModBlocks.register("soulstone_smooth", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 1.5f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> SOUL_GLASS = ModBlocks.register("soul_glass", () -> new BaseGlassBlock(Material.field_151592_s, SoundType.field_185853_f, 0.3f, 0.3f));
    public static final RegistryObject<Block> SOULSTONE_SLAB = ModBlocks.register("soulstone_slab", () -> new BaseSlabBlock(Material.field_151576_e, SoundType.field_185851_d, 1.5f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> SOULSTONE_COBBLE_SLAB = ModBlocks.register("soulstone_cobble_slab", () -> new BaseSlabBlock(Material.field_151576_e, SoundType.field_185851_d, 2.0f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> SOULSTONE_BRICKS_SLAB = ModBlocks.register("soulstone_bricks_slab", () -> new BaseSlabBlock(Material.field_151576_e, SoundType.field_185851_d, 1.5f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> SOULSTONE_SMOOTH_SLAB = ModBlocks.register("soulstone_smooth_slab", () -> new BaseSlabBlock(Material.field_151576_e, SoundType.field_185851_d, 1.5f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> SOULSTONE_STAIRS = ModBlocks.register("soulstone_stairs", () -> new BaseStairsBlock(SOULSTONE.lazyMap(Block::func_176223_P), Material.field_151576_e, SoundType.field_185851_d, 1.5f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> SOULSTONE_COBBLE_STAIRS = ModBlocks.register("soulstone_cobble_stairs", () -> new BaseStairsBlock(SOULSTONE_COBBLE.lazyMap(Block::func_176223_P), Material.field_151576_e, SoundType.field_185851_d, 2.0f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> SOULSTONE_BRICKS_STAIRS = ModBlocks.register("soulstone_bricks_stairs", () -> new BaseStairsBlock(SOULSTONE_BRICKS.lazyMap(Block::func_176223_P), Material.field_151576_e, SoundType.field_185851_d, 1.5f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> SOULSTONE_COBBLE_WALL = ModBlocks.register("soulstone_cobble_wall", () -> new BaseWallBlock(Material.field_151576_e, SoundType.field_185851_d, 2.0f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> SOULSTONE_BRICKS_WALL = ModBlocks.register("soulstone_bricks_wall", () -> new BaseWallBlock(Material.field_151576_e, SoundType.field_185851_d, 1.5f, 6.0f, ToolType.PICKAXE));
    public static final RegistryObject<Block> WITHERPROOF_BLOCK = ModBlocks.register("witherproof_block", WitherproofBlock::new);
    public static final RegistryObject<Block> WITHERPROOF_BRICKS = ModBlocks.register("witherproof_bricks", WitherproofBlock::new);
    public static final RegistryObject<Block> WITHERPROOF_GLASS = ModBlocks.register("witherproof_glass", WitherproofGlassBlock::new);
    public static final RegistryObject<Block> INFUSION_PEDESTAL = ModBlocks.register("infusion_pedestal", InfusionPedestalBlock::new);
    public static final RegistryObject<Block> INFUSION_ALTAR = ModBlocks.register("infusion_altar", InfusionAltarBlock::new);
    public static final RegistryObject<Block> TINKERING_TABLE = ModBlocks.register("tinkering_table", TinkeringTableBlock::new);
    public static final RegistryObject<Block> MACHINE_FRAME = ModBlocks.register("machine_frame", () -> new BaseBlock(Material.field_151576_e, SoundType.field_185851_d, 1.5f, 6.0f));
    public static final RegistryObject<Block> BASIC_REPROCESSOR = ModBlocks.register("basic_reprocessor", () -> new ReprocessorBlock(ReprocessorTier.BASIC));
    public static final RegistryObject<Block> INFERIUM_REPROCESSOR = ModBlocks.register("inferium_reprocessor", () -> new ReprocessorBlock(ReprocessorTier.INFERIUM));
    public static final RegistryObject<Block> PRUDENTIUM_REPROCESSOR = ModBlocks.register("prudentium_reprocessor", () -> new ReprocessorBlock(ReprocessorTier.PRUDENTIUM));
    public static final RegistryObject<Block> TERTIUM_REPROCESSOR = ModBlocks.register("tertium_reprocessor", () -> new ReprocessorBlock(ReprocessorTier.TERTIUM));
    public static final RegistryObject<Block> IMPERIUM_REPROCESSOR = ModBlocks.register("imperium_reprocessor", () -> new ReprocessorBlock(ReprocessorTier.IMPERIUM));
    public static final RegistryObject<Block> SUPREMIUM_REPROCESSOR = ModBlocks.register("supremium_reprocessor", () -> new ReprocessorBlock(ReprocessorTier.SUPREMIUM));
    public static final RegistryObject<Block> SOUL_EXTRACTOR = ModBlocks.register("soul_extractor", SoulExtractorBlock::new);
    public static final RegistryObject<Block> INFERIUM_CROP = ModBlocks.registerNoItem("inferium_crop", () -> new InferiumCropBlock(ModCrops.INFERIUM));

    @SubscribeEvent
    public void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        ENTRIES.forEach((reg, block) -> {
            registry.register((IForgeRegistryEntry)block.get());
            reg.updateReference(registry);
        });
        CropRegistry.getInstance().setAllowRegistration(true);
        CropRegistry.getInstance().onRegisterBlocks((IForgeRegistry<Block>)registry);
        CropRegistry.getInstance().setAllowRegistration(false);
    }

    private static RegistryObject<Block> register(String name, Supplier<Block> block) {
        return ModBlocks.register(name, block, b -> () -> new BaseBlockItem((Block)b.get(), p -> p.func_200916_a(MysticalAgriculture.ITEM_GROUP)));
    }

    private static RegistryObject<Block> register(String name, Supplier<Block> block, Function<RegistryObject<Block>, Supplier<? extends BlockItem>> item) {
        ResourceLocation loc = new ResourceLocation("mysticalagriculture", name);
        RegistryObject reg = RegistryObject.of((ResourceLocation)loc, (IForgeRegistry)ForgeRegistries.BLOCKS);
        ENTRIES.put((RegistryObject<Block>)reg, () -> (Block)((Block)block.get()).setRegistryName(loc));
        ModItems.BLOCK_ENTRIES.add(() -> (Item)((BlockItem)((Supplier)item.apply(reg)).get()).setRegistryName(loc));
        return reg;
    }

    public static RegistryObject<Block> registerNoItem(String name, Supplier<Block> block) {
        ResourceLocation loc = new ResourceLocation("mysticalagriculture", name);
        RegistryObject reg = RegistryObject.of((ResourceLocation)loc, (IForgeRegistry)ForgeRegistries.BLOCKS);
        ENTRIES.put((RegistryObject<Block>)reg, () -> (Block)((Block)block.get()).setRegistryName(loc));
        return reg;
    }
}

