/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiWindow;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.InventoryContainerSlot;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.lib.LRU;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.Pair;

public abstract class GuiMekanism<CONTAINER extends Container>
extends ContainerScreen<CONTAINER>
implements IGuiWrapper,
IFancyFontRenderer {
    public static final ResourceLocation BASE_BACKGROUND = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "base.png");
    public static final ResourceLocation SHADOW = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "shadow.png");
    public static final ResourceLocation BLUR = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "blur.png");
    protected boolean dynamicSlots;
    protected final LRU<GuiWindow> windows = new LRU();
    protected final List<GuiElement> focusListeners = new ArrayList<GuiElement>();
    private boolean hasClicked = false;
    public static int maxZOffset;

    protected GuiMekanism(CONTAINER container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.initPreSlots();
        if (this.dynamicSlots) {
            this.addSlots();
        }
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.field_230705_e_.stream().filter(child -> child instanceof GuiElement).map(child -> (GuiElement)child).forEach(GuiElement::tick);
    }

    protected void initPreSlots() {
    }

    protected GuiElement.IHoverable getOnHover(ILangEntry translationHelper) {
        return this.getOnHover(() -> translationHelper.translate(new Object[0]));
    }

    protected GuiElement.IHoverable getOnHover(Supplier<ITextComponent> componentSupplier) {
        return (onHover, matrix, xAxis, yAxis) -> this.displayTooltip(matrix, (ITextComponent)componentSupplier.get(), xAxis, yAxis);
    }

    protected ResourceLocation getButtonLocation(String name) {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, name + ".png");
    }

    @Override
    public void addFocusListener(GuiElement element) {
        this.focusListeners.add(element);
    }

    @Override
    public void removeFocusListener(GuiElement element) {
        this.focusListeners.remove(element);
    }

    @Override
    public void focusChange(GuiElement changed) {
        this.focusListeners.stream().filter(e -> e != changed).forEach(e -> e.func_230996_d_(false));
    }

    @Override
    public void incrementFocus(GuiElement current) {
        int index = this.focusListeners.indexOf(current);
        if (index != -1) {
            GuiElement next = this.focusListeners.get((index + 1) % this.focusListeners.size());
            next.func_230996_d_(true);
            this.focusChange(next);
        }
    }

    protected boolean func_195361_a(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        return this.getWindowHovering(mouseX, mouseY) == null && super.func_195361_a(mouseX, mouseY, guiLeftIn, guiTopIn, mouseButton);
    }

    public void func_231152_a_(@Nonnull Minecraft minecraft, int sizeX, int sizeY) {
        ArrayList<Pair> prevElements = new ArrayList<Pair>();
        for (int i = 0; i < this.field_230710_m_.size(); ++i) {
            Widget widget = (Widget)this.field_230710_m_.get(i);
            if (!(widget instanceof GuiElement) || !((GuiElement)widget).hasPersistentData()) continue;
            prevElements.add(Pair.of((Object)i, (Object)((GuiElement)widget)));
        }
        this.focusListeners.removeIf(element -> !element.isOverlay);
        int prevLeft = this.field_147003_i;
        int prevTop = this.field_147009_r;
        super.func_231152_a_(minecraft, sizeX, sizeY);
        this.windows.forEach(window -> {
            window.resize(prevLeft, prevTop, this.field_147003_i, this.field_147009_r);
            this.field_230705_e_.add(window);
        });
        prevElements.forEach(e -> {
            Widget widget;
            if ((Integer)e.getLeft() < this.field_230710_m_.size() && (widget = (Widget)this.field_230710_m_.get((Integer)e.getLeft())).getClass() == ((GuiElement)e.getRight()).getClass()) {
                ((GuiElement)widget).syncFrom((GuiElement)e.getRight());
            }
        });
    }

    protected void func_230451_b_(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        matrix.func_227861_a_(0.0, 0.0, 300.0);
        RenderSystem.translatef((float)(-this.field_147003_i), (float)(-this.field_147009_r), (float)0.0f);
        this.children().stream().filter(c -> c instanceof GuiElement).forEach(c -> ((GuiElement)c).onDrawBackground(matrix, mouseX, mouseY, MekanismRenderer.getPartialTick()));
        RenderSystem.translatef((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        this.drawForegroundText(matrix, mouseX, mouseY);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        maxZOffset = 200;
        int zOffset = 200;
        for (Widget widget : this.field_230710_m_) {
            if (!(widget instanceof GuiElement)) continue;
            matrix.func_227860_a_();
            ((GuiElement)widget).onRenderForeground(matrix, mouseX, mouseY, zOffset, zOffset);
            matrix.func_227865_b_();
        }
        zOffset = maxZOffset;
        LRU.LRUIterator iter = this.getWindowsDescendingIterator();
        while (iter.hasNext()) {
            GuiWindow overlay = (GuiWindow)iter.next();
            matrix.func_227860_a_();
            overlay.onRenderForeground(matrix, mouseX, mouseY, zOffset += 150, zOffset);
            if (iter.hasNext()) {
                overlay.renderBlur(matrix);
            }
            matrix.func_227865_b_();
        }
        GuiElement tooltipElement = this.getWindowHovering(mouseX, mouseY);
        if (tooltipElement == null) {
            for (int i = this.field_230710_m_.size() - 1; i >= 0; --i) {
                Widget widget = (Widget)this.field_230710_m_.get(i);
                if (!(widget instanceof GuiElement) || !widget.func_231047_b_((double)mouseX, (double)mouseY)) continue;
                tooltipElement = (GuiElement)widget;
                break;
            }
        }
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)maxZOffset);
        if (tooltipElement != null) {
            tooltipElement.func_230443_a_(matrix, xAxis, yAxis);
        }
        RenderSystem.translatef((float)(-this.field_147003_i), (float)(-this.field_147009_r), (float)0.0f);
        this.func_230459_a_(matrix, mouseX, mouseY);
        RenderSystem.translatef((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)200.0f);
    }

    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
    }

    @Nonnull
    public Optional<IGuiEventListener> func_212930_a(double mouseX, double mouseY) {
        GuiWindow window = this.getWindowHovering(mouseX, mouseY);
        return window != null ? Optional.of(window) : super.func_212930_a(mouseX, mouseY);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        this.hasClicked = true;
        GuiWindow top = this.windows.isEmpty() ? null : (GuiWindow)this.windows.iterator().next();
        GuiWindow focused = this.windows.stream().filter(overlay -> overlay.func_231044_a_(mouseX, mouseY, button)).findFirst().orElse(null);
        if (focused != null) {
            this.func_231035_a_((IGuiEventListener)focused);
            if (button == 0) {
                this.func_231037_b__(true);
            }
            if (top != focused) {
                this.windows.moveUp(focused);
            }
            return true;
        }
        for (int i = this.field_230710_m_.size() - 1; i >= 0; --i) {
            IGuiEventListener listener = (IGuiEventListener)this.field_230710_m_.get(i);
            if (!listener.func_231044_a_(mouseX, mouseY, button)) continue;
            this.func_231035_a_(listener);
            if (button == 0) {
                this.func_231037_b__(true);
            }
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (this.hasClicked) {
            this.windows.forEach(w -> w.func_231000_a__(mouseX, mouseY));
            return super.func_231048_c_(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        return this.windows.stream().anyMatch(window -> window.func_231046_a_(keyCode, scanCode, modifiers)) || GuiUtils.checkChildren(this.field_230710_m_, child -> child.func_231046_a_(keyCode, scanCode, modifiers)) || super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char c, int keyCode) {
        return this.windows.stream().anyMatch(window -> window.func_231042_a_(c, keyCode)) || GuiUtils.checkChildren(this.field_230710_m_, child -> child.func_231042_a_(c, keyCode)) || super.func_231042_a_(c, keyCode);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double mouseXOld, double mouseYOld) {
        super.func_231045_a_(mouseX, mouseY, button, mouseXOld, mouseYOld);
        return this.func_241217_q_() != null && this.func_231041_ay__() && button == 0 && this.func_241217_q_().func_231045_a_(mouseX, mouseY, button, mouseXOld, mouseYOld);
    }

    protected boolean isMouseOverSlot(Slot slot, double mouseX, double mouseY) {
        return this.func_195359_a(slot.field_75223_e, slot.field_75221_f, 16, 16, mouseX, mouseY);
    }

    protected boolean func_195359_a(int x, int y, int width, int height, double mouseX, double mouseY) {
        return super.func_195359_a(x, y, width, height, mouseX, mouseY) && this.getWindowHovering(mouseX, mouseY) == null && this.field_230710_m_.stream().noneMatch(button -> button.func_231047_b_(mouseX, mouseY));
    }

    protected void addSlots() {
        int size = this.field_147002_h.field_75151_b.size();
        for (int i = 0; i < size; ++i) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(i);
            if (slot instanceof InventoryContainerSlot) {
                SlotType type;
                InventoryContainerSlot containerSlot = (InventoryContainerSlot)slot;
                ContainerSlotType slotType = containerSlot.getSlotType();
                DataType dataType = this.findDataType(containerSlot);
                if (dataType != null) {
                    type = SlotType.get(dataType);
                } else if (slotType == ContainerSlotType.INPUT || slotType == ContainerSlotType.OUTPUT || slotType == ContainerSlotType.EXTRA) {
                    type = SlotType.NORMAL;
                } else if (slotType == ContainerSlotType.POWER) {
                    type = SlotType.POWER;
                } else {
                    if (slotType != ContainerSlotType.NORMAL && slotType != ContainerSlotType.VALIDITY) continue;
                    type = SlotType.NORMAL;
                }
                GuiSlot guiSlot = new GuiSlot(type, this, slot.field_75223_e - 1, slot.field_75221_f - 1);
                SlotOverlay slotOverlay = containerSlot.getSlotOverlay();
                if (slotOverlay != null) {
                    guiSlot.with(slotOverlay);
                }
                if (slotType == ContainerSlotType.VALIDITY) {
                    int index = i;
                    guiSlot.validity(() -> this.checkValidity(index));
                }
                this.func_230480_a_(guiSlot);
                continue;
            }
            this.func_230480_a_(new GuiSlot(SlotType.NORMAL, this, slot.field_75223_e - 1, slot.field_75221_f - 1));
        }
    }

    @Nullable
    protected DataType findDataType(InventoryContainerSlot slot) {
        Object tileEntity;
        if (this.field_147002_h instanceof MekanismTileContainer && (tileEntity = ((MekanismTileContainer)this.field_147002_h).getTileEntity()) instanceof ISideConfiguration) {
            return ((ISideConfiguration)tileEntity).getActiveDataType(slot.getInventorySlot());
        }
        return null;
    }

    protected ItemStack checkValidity(int slotIndex) {
        return ItemStack.field_190927_a;
    }

    protected void func_230450_a_(@Nonnull MatrixStack matrix, float partialTick, int mouseX, int mouseY) {
        MekanismRenderer.resetColor();
        if (this.field_230708_k_ < 8 || this.field_230709_l_ < 8) {
            Mekanism.logger.warn("Gui: {}, was too small to draw the background of. Unable to draw a background for a gui smaller than 8 by 8.", (Object)this.getClass().getSimpleName());
            return;
        }
        GuiUtils.renderBackgroundTexture(matrix, BASE_BACKGROUND, 4, 4, this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g, 256, 256);
    }

    @Override
    public FontRenderer getFont() {
        return this.field_230712_o_;
    }

    public void func_230430_a_(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.translated((double)0.0, (double)0.0, (double)-500.0);
        matrix.func_227860_a_();
        this.func_230446_a_(matrix);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        matrix.func_227865_b_();
        RenderSystem.translated((double)0.0, (double)0.0, (double)500.0);
    }

    @Override
    public void renderItemTooltip(MatrixStack matrix, @Nonnull ItemStack stack, int xAxis, int yAxis) {
        this.func_230457_a_(matrix, stack, xAxis, yAxis);
    }

    @Override
    public void renderItemTooltipWithExtra(MatrixStack matrix, @Nonnull ItemStack stack, int xAxis, int yAxis, List<ITextComponent> toAppend) {
        if (toAppend.isEmpty()) {
            this.renderItemTooltip(matrix, stack, xAxis, yAxis);
        } else {
            FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
            net.minecraftforge.fml.client.gui.GuiUtils.preItemToolTip((ItemStack)stack);
            ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>(this.func_231151_a_(stack));
            tooltip.addAll(toAppend);
            this.renderWrappedToolTip(matrix, tooltip, xAxis, yAxis, font == null ? this.field_230712_o_ : font);
            net.minecraftforge.fml.client.gui.GuiUtils.postItemToolTip();
        }
    }

    @Override
    public ItemRenderer getItemRenderer() {
        return this.field_230707_j_;
    }

    @Override
    public void addWindow(GuiWindow window) {
        this.windows.add(window);
    }

    @Override
    public void removeWindow(GuiWindow window) {
        this.windows.remove(window);
    }

    @Override
    @Nullable
    public GuiWindow getWindowHovering(double mouseX, double mouseY) {
        return this.windows.stream().filter(w -> w.func_231047_b_(mouseX, mouseY)).findFirst().orElse(null);
    }

    public Collection<GuiWindow> getWindows() {
        return this.windows;
    }

    public List<IGuiEventListener> children() {
        return this.field_230705_e_;
    }

    public LRU.LRUIterator getWindowsDescendingIterator() {
        return this.windows.descendingIterator();
    }
}

