/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.transmitter.acceptor;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.chemical.BoxedChemicalHandler;
import mekanism.common.content.network.transmitter.BoxedPressurizedTube;
import mekanism.common.lib.transmitter.acceptor.AbstractAcceptorCache;
import mekanism.common.lib.transmitter.acceptor.AbstractAcceptorInfo;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.CapabilityUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BoxedChemicalAcceptorCache
extends AbstractAcceptorCache<BoxedChemicalHandler, BoxedChemicalAcceptorInfo> {
    public BoxedChemicalAcceptorCache(BoxedPressurizedTube transmitter, TileEntityTransmitter transmitterTile) {
        super(transmitter, transmitterTile);
    }

    private void updateCachedAcceptorAndListen(Direction side, TileEntity acceptorTile, BoxedChemicalHandler acceptor) {
        boolean dirtyAcceptor = false;
        if (this.cachedAcceptors.containsKey(side)) {
            BoxedChemicalAcceptorInfo acceptorInfo = (BoxedChemicalAcceptorInfo)this.cachedAcceptors.get(side);
            if (acceptorTile != acceptorInfo.getTile()) {
                this.cachedAcceptors.put(side, new BoxedChemicalAcceptorInfo(acceptorTile, acceptor));
                dirtyAcceptor = true;
            } else if (!acceptor.sameHandlers(acceptorInfo.boxedHandler)) {
                acceptorInfo.updateAcceptor(acceptor);
                dirtyAcceptor = true;
            }
        } else {
            this.cachedAcceptors.put(side, new BoxedChemicalAcceptorInfo(acceptorTile, acceptor));
            dirtyAcceptor = true;
        }
        if (dirtyAcceptor) {
            this.transmitter.markDirtyAcceptor(side);
            acceptor.addRefreshListeners(this.getRefreshListener(side));
        }
    }

    public boolean isChemicalAcceptorAndListen(@Nullable TileEntity tile, Direction side) {
        Direction opposite = side.func_176734_d();
        LazyOptional<IGasHandler> gasAcceptor = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.GAS_HANDLER_CAPABILITY, opposite);
        LazyOptional<IInfusionHandler> infusionAcceptor = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.INFUSION_HANDLER_CAPABILITY, opposite);
        LazyOptional<IPigmentHandler> pigmentAcceptor = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.PIGMENT_HANDLER_CAPABILITY, opposite);
        LazyOptional<ISlurryHandler> slurryAcceptor = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.SLURRY_HANDLER_CAPABILITY, opposite);
        if (gasAcceptor.isPresent() || infusionAcceptor.isPresent() || pigmentAcceptor.isPresent() || slurryAcceptor.isPresent()) {
            BoxedChemicalHandler chemicalHandler = new BoxedChemicalHandler();
            if (gasAcceptor.isPresent()) {
                chemicalHandler.addGasHandler(gasAcceptor);
            }
            if (infusionAcceptor.isPresent()) {
                chemicalHandler.addInfusionHandler(infusionAcceptor);
            }
            if (pigmentAcceptor.isPresent()) {
                chemicalHandler.addPigmentHandler(pigmentAcceptor);
            }
            if (slurryAcceptor.isPresent()) {
                chemicalHandler.addSlurryHandler(slurryAcceptor);
            }
            this.updateCachedAcceptorAndListen(side, tile, chemicalHandler);
            return true;
        }
        return false;
    }

    @Override
    public List<BoxedChemicalHandler> getConnectedAcceptors(Set<Direction> sides) {
        ArrayList<BoxedChemicalHandler> acceptors = new ArrayList<BoxedChemicalHandler>(sides.size());
        for (Direction side : sides) {
            BoxedChemicalAcceptorInfo acceptorInfo;
            if (!this.cachedAcceptors.containsKey(side) || (acceptorInfo = (BoxedChemicalAcceptorInfo)this.cachedAcceptors.get(side)).getTile().func_145837_r()) continue;
            acceptors.add(acceptorInfo.boxedHandler);
        }
        return acceptors;
    }

    @Override
    public LazyOptional<BoxedChemicalHandler> getConnectedAcceptor(Direction side) {
        BoxedChemicalAcceptorInfo acceptorInfo;
        if (this.cachedAcceptors.containsKey(side) && !(acceptorInfo = (BoxedChemicalAcceptorInfo)this.cachedAcceptors.get(side)).getTile().func_145837_r()) {
            return acceptorInfo.getAsLazy();
        }
        return LazyOptional.empty();
    }

    public static class BoxedChemicalAcceptorInfo
    extends AbstractAcceptorInfo {
        private BoxedChemicalHandler boxedHandler;
        @Nullable
        private LazyOptional<BoxedChemicalHandler> asLazy;

        private BoxedChemicalAcceptorInfo(TileEntity tile, BoxedChemicalHandler boxedHandler) {
            super(tile);
            this.boxedHandler = boxedHandler;
        }

        public void updateAcceptor(BoxedChemicalHandler acceptor) {
            this.boxedHandler = acceptor;
            this.asLazy = null;
        }

        private LazyOptional<BoxedChemicalHandler> getAsLazy() {
            if (this.asLazy == null) {
                this.asLazy = LazyOptional.of(() -> this.boxedHandler);
            }
            return this.asLazy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BoxedChemicalAcceptorInfo other = (BoxedChemicalAcceptorInfo)o;
            return this.boxedHandler.equals(other.boxedHandler);
        }

        public int hashCode() {
            return this.boxedHandler.hashCode();
        }
    }
}

