/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.function.Supplier;
import mekanism.common.Mekanism;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.inventory.container.item.FrequencyItemContainer;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyManager;
import mekanism.common.lib.frequency.IFrequencyItem;
import mekanism.common.network.PacketFrequencyItemGuiUpdate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketGuiItemDataRequest {
    private final Type type;
    private final Hand hand;

    public PacketGuiItemDataRequest(Type type, Hand hand) {
        this.type = type;
        this.hand = hand;
    }

    public static PacketGuiItemDataRequest frequencyList(Hand hand) {
        return new PacketGuiItemDataRequest(Type.FREQUENCY_LIST_GUI, hand);
    }

    public static PacketGuiItemDataRequest qioItemViewer() {
        return new PacketGuiItemDataRequest(Type.QIO_ITEM_VIEWER, null);
    }

    public static void handle(PacketGuiItemDataRequest message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ServerPlayerEntity player = ctx.getSender();
            if (player != null) {
                if (message.type == Type.FREQUENCY_LIST_GUI) {
                    if (player.field_71070_bA instanceof FrequencyItemContainer) {
                        PacketGuiItemDataRequest.handleFrequencyList(message, (PlayerEntity)player);
                    }
                } else if (message.type == Type.QIO_ITEM_VIEWER && player.field_71070_bA instanceof QIOItemViewerContainer) {
                    QIOItemViewerContainer container = (QIOItemViewerContainer)player.field_71070_bA;
                    QIOFrequency freq = container.getFrequency();
                    if (!player.field_70170_p.func_201670_d() && freq != null) {
                        freq.openItemViewer(player);
                    }
                }
            }
        });
        ctx.setPacketHandled(true);
    }

    private static <FREQ extends Frequency> void handleFrequencyList(PacketGuiItemDataRequest message, PlayerEntity player) {
        FrequencyManager manager;
        FrequencyItemContainer container = (FrequencyItemContainer)player.field_71070_bA;
        ItemStack stack = player.func_184586_b(message.hand);
        Frequency.FrequencyIdentity identity = ((IFrequencyItem)stack.func_77973_b()).getFrequency(stack);
        Frequency freq = null;
        if (identity != null && (freq = (Frequency)(manager = identity.isPublic() ? container.getFrequencyType().getManager(null) : container.getFrequencyType().getManager(player.func_110124_au())).getFrequency(identity.getKey())) == null) {
            ((IFrequencyItem)stack.func_77973_b()).setFrequency(stack, null);
        }
        Mekanism.packetHandler.sendTo(PacketFrequencyItemGuiUpdate.update(message.hand, container.getFrequencyType(), player.func_110124_au(), freq), (ServerPlayerEntity)player);
    }

    public static void encode(PacketGuiItemDataRequest pkt, PacketBuffer buf) {
        buf.func_179249_a((Enum)pkt.type);
        if (pkt.type == Type.FREQUENCY_LIST_GUI) {
            buf.func_179249_a((Enum)pkt.hand);
        }
    }

    public static PacketGuiItemDataRequest decode(PacketBuffer buf) {
        Type type = (Type)buf.func_179257_a(Type.class);
        Hand hand = null;
        if (type == Type.FREQUENCY_LIST_GUI) {
            hand = (Hand)buf.func_179257_a(Hand.class);
        }
        return new PacketGuiItemDataRequest(type, hand);
    }

    private static enum Type {
        FREQUENCY_LIST_GUI,
        QIO_ITEM_VIEWER;

    }
}

