/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.function.Supplier;
import mekanism.common.Mekanism;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyManager;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.frequency.IFrequencyHandler;
import mekanism.common.lib.frequency.IFrequencyItem;
import mekanism.common.network.PacketFrequencyItemGuiUpdate;
import mekanism.common.util.WorldUtils;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketGuiSetFrequency<FREQ extends Frequency> {
    private final FrequencyType<FREQ> type;
    private final FrequencyUpdate updateType;
    private final Frequency.FrequencyIdentity data;
    private final BlockPos tilePosition;
    private final Hand currentHand;

    private PacketGuiSetFrequency(FrequencyUpdate updateType, FrequencyType<FREQ> type, Frequency.FrequencyIdentity data, BlockPos tilePosition, Hand currentHand) {
        this.updateType = updateType;
        this.type = type;
        this.data = data;
        this.tilePosition = tilePosition;
        this.currentHand = currentHand;
    }

    public static <FREQ extends Frequency> PacketGuiSetFrequency<FREQ> create(FrequencyUpdate updateType, FrequencyType<FREQ> type, Frequency.FrequencyIdentity data, BlockPos tilePosition) {
        return new PacketGuiSetFrequency<FREQ>(updateType, type, data, tilePosition, null);
    }

    public static <FREQ extends Frequency> PacketGuiSetFrequency<FREQ> create(FrequencyUpdate updateType, FrequencyType<FREQ> type, Frequency.FrequencyIdentity data, Hand currentHand) {
        return new PacketGuiSetFrequency<FREQ>(updateType, type, data, null, currentHand);
    }

    public static <FREQ extends Frequency> void handle(PacketGuiSetFrequency<FREQ> message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ServerPlayerEntity player = ctx.getSender();
            if (player == null) {
                return;
            }
            if (message.updateType.isTile()) {
                TileEntity tile = WorldUtils.getTileEntity((IBlockReader)player.field_70170_p, message.tilePosition);
                if (tile instanceof IFrequencyHandler) {
                    if (message.updateType == FrequencyUpdate.SET_TILE) {
                        ((IFrequencyHandler)tile).setFrequency(message.type, message.data);
                    } else if (message.updateType == FrequencyUpdate.REMOVE_TILE) {
                        ((IFrequencyHandler)tile).removeFrequency(message.type, message.data);
                    }
                }
            } else {
                FrequencyManager manager = message.type.getManager(message.data.isPublic() ? null : player.func_110124_au());
                ItemStack stack = player.func_184586_b(message.currentHand);
                if (stack.func_77973_b() instanceof IFrequencyItem) {
                    IFrequencyItem item = (IFrequencyItem)stack.func_77973_b();
                    Frequency toUse = null;
                    if (message.updateType == FrequencyUpdate.SET_ITEM) {
                        toUse = (Frequency)manager.getOrCreateFrequency(message.data, player.func_110124_au());
                        item.setFrequency(stack, toUse);
                    } else if (message.updateType == FrequencyUpdate.REMOVE_ITEM) {
                        manager.remove(message.data.getKey(), player.func_110124_au());
                        Frequency.FrequencyIdentity current = item.getFrequency(stack);
                        if (current != null) {
                            if (current.equals(message.data)) {
                                item.setFrequency(stack, null);
                            } else {
                                FrequencyManager currentManager = manager;
                                if (message.data.isPublic() != current.isPublic()) {
                                    currentManager = message.type.getManager(current.isPublic() ? null : player.func_110124_au());
                                }
                                toUse = (Frequency)currentManager.getFrequency(current.getKey());
                            }
                        }
                    }
                    Mekanism.packetHandler.sendTo(PacketFrequencyItemGuiUpdate.update(message.currentHand, message.type, player.func_110124_au(), toUse), player);
                }
            }
        });
        ctx.setPacketHandled(true);
    }

    public static <FREQ extends Frequency> void encode(PacketGuiSetFrequency<FREQ> pkt, PacketBuffer buf) {
        buf.func_179249_a((Enum)pkt.updateType);
        pkt.type.write(buf);
        pkt.type.getIdentitySerializer().write(buf, pkt.data);
        if (pkt.updateType.isTile()) {
            buf.func_179255_a(pkt.tilePosition);
        } else {
            buf.func_179249_a((Enum)pkt.currentHand);
        }
    }

    public static <FREQ extends Frequency> PacketGuiSetFrequency<FREQ> decode(PacketBuffer buf) {
        FrequencyUpdate updateType = (FrequencyUpdate)buf.func_179257_a(FrequencyUpdate.class);
        FrequencyType type = FrequencyType.load(buf);
        Frequency.FrequencyIdentity data = type.getIdentitySerializer().read(buf);
        BlockPos pos = updateType.isTile() ? buf.func_179259_c() : null;
        Hand hand = !updateType.isTile() ? (Hand)buf.func_179257_a(Hand.class) : null;
        return new PacketGuiSetFrequency(updateType, type, data, pos, hand);
    }

    public static enum FrequencyUpdate {
        SET_TILE,
        SET_ITEM,
        REMOVE_TILE,
        REMOVE_ITEM;


        boolean isTile() {
            return this == SET_TILE || this == REMOVE_TILE;
        }
    }
}

