/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.IAlloyInteraction;
import mekanism.api.IConfigurable;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.tier.AlloyTier;
import mekanism.api.tier.BaseTier;
import mekanism.client.model.data.TransmitterModelData;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.block.interfaces.IHasTileEntity;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.block.transmitter.BlockLargeTransmitter;
import mekanism.common.block.transmitter.BlockSmallTransmitter;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.DynamicHandler;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.content.network.transmitter.BufferedTransmitter;
import mekanism.common.content.network.transmitter.IUpgradeableTransmitter;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.lib.transmitter.DynamicBufferedNetwork;
import mekanism.common.lib.transmitter.DynamicNetwork;
import mekanism.common.lib.transmitter.TransmitterNetworkRegistry;
import mekanism.common.tile.base.CapabilityTileEntity;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MultipartUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import org.apache.commons.lang3.tuple.Pair;

public abstract class TileEntityTransmitter
extends CapabilityTileEntity
implements IConfigurable,
ITickableTileEntity,
IAlloyInteraction {
    public static final ModelProperty<TransmitterModelData> TRANSMITTER_PROPERTY = new ModelProperty();
    private final Transmitter<?, ?, ?> transmitter;
    private boolean forceUpdate = true;
    private boolean loaded = false;

    public TileEntityTransmitter(IBlockProvider blockProvider) {
        super(((IHasTileEntity)blockProvider.getBlock()).getTileType());
        this.transmitter = this.createTransmitter(blockProvider);
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.ALLOY_INTERACTION_CAPABILITY, this));
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIGURABLE_CAPABILITY, this));
    }

    protected abstract Transmitter<?, ?, ?> createTransmitter(IBlockProvider var1);

    public Transmitter<?, ?, ?> getTransmitter() {
        return this.transmitter;
    }

    public void setForceUpdate() {
        this.forceUpdate = true;
    }

    public abstract TransmitterType getTransmitterType();

    public void func_73660_a() {
        if (!this.isRemote() && this.forceUpdate) {
            this.getTransmitter().refreshConnections();
            this.forceUpdate = false;
        }
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        return this.getTransmitter().getReducedUpdateTag(super.getReducedUpdateTag());
    }

    @Override
    public void handleUpdateTag(BlockState state, @Nonnull CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.getTransmitter().handleUpdateTag(tag);
    }

    @Override
    public void handleUpdatePacket(@Nonnull CompoundNBT tag) {
        super.handleUpdatePacket(tag);
        this.requestModelDataUpdate();
        WorldUtils.updateBlock(this.func_145831_w(), this.func_174877_v(), this);
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbtTags) {
        super.func_230337_a_(state, nbtTags);
        this.getTransmitter().read(nbtTags);
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbtTags) {
        return this.getTransmitter().write(super.func_189515_b(nbtTags));
    }

    public void onNeighborTileChange(Direction side) {
        this.getTransmitter().onNeighborTileChange(side);
    }

    public void onNeighborBlockChange(Direction side) {
        this.getTransmitter().onNeighborBlockChange(side);
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.onWorldJoin();
    }

    public void onChunkUnloaded() {
        if (!this.isRemote()) {
            this.getTransmitter().takeShare();
        }
        this.onWorldSeparate();
        this.getTransmitter().onChunkUnload();
        super.onChunkUnloaded();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.onWorldSeparate();
        this.getTransmitter().remove();
    }

    public void onAdded() {
        this.onWorldJoin();
        this.getTransmitter().refreshConnections();
    }

    private void onWorldJoin() {
        this.loaded = true;
        if (!this.isRemote()) {
            TransmitterNetworkRegistry.registerOrphanTransmitter(this.getTransmitter());
        }
    }

    private void onWorldSeparate() {
        this.loaded = false;
        if (this.isRemote()) {
            this.getTransmitter().setTransmitterNetwork(null);
        } else {
            TransmitterNetworkRegistry.invalidateTransmitter(this.getTransmitter());
        }
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public ActionResultType onSneakRightClick(PlayerEntity player, Direction side) {
        if (!this.isRemote()) {
            Direction hitSide;
            Pair<Vector3d, Vector3d> vecs = MultipartUtils.getRayTraceVectors((Entity)player);
            MultipartUtils.AdvancedRayTraceResult result = MultipartUtils.collisionRayTrace(this.func_174877_v(), (Vector3d)vecs.getLeft(), (Vector3d)vecs.getRight(), this.getCollisionBoxes());
            if (result == null) {
                return ActionResultType.PASS;
            }
            ArrayList<Direction> list = new ArrayList<Direction>();
            byte connections = this.getTransmitter().getAllCurrentConnections();
            for (Direction dir : EnumUtils.DIRECTIONS) {
                if (!Transmitter.connectionMapContainsSide(connections, dir)) continue;
                list.add(dir);
            }
            int boxIndex = result.hit.subHit + 1;
            if (boxIndex < list.size()) {
                hitSide = (Direction)list.get(boxIndex);
            } else {
                if (this.transmitter.getConnectionTypeRaw(side) != ConnectionType.NONE && this.onConfigure(player, side) == ActionResultType.SUCCESS) {
                    this.getTransmitter().refreshConnections();
                    this.getTransmitter().notifyTileChange();
                    return ActionResultType.SUCCESS;
                }
                hitSide = side;
            }
            this.transmitter.setConnectionTypeRaw(hitSide, (ConnectionType)this.transmitter.getConnectionTypeRaw(hitSide).getNext());
            this.getTransmitter().onModeChange(Direction.func_82600_a((int)hitSide.ordinal()));
            this.getTransmitter().refreshConnections();
            this.getTransmitter().notifyTileChange();
            player.func_145747_a((ITextComponent)MekanismLang.CONNECTION_TYPE.translate(this.transmitter.getConnectionTypeRaw(hitSide)), Util.field_240973_b_);
            this.sendUpdatePacket();
        }
        return ActionResultType.SUCCESS;
    }

    protected ActionResultType onConfigure(PlayerEntity player, Direction side) {
        return this.getTransmitter().onConfigure(player, side);
    }

    @Override
    public ActionResultType onRightClick(PlayerEntity player, Direction side) {
        return this.getTransmitter().onRightClick(player, side);
    }

    public List<VoxelShape> getCollisionBoxes() {
        ArrayList<VoxelShape> list = new ArrayList<VoxelShape>();
        boolean isSmall = this.getTransmitterType().getSize() == TransmitterType.Size.SMALL;
        for (Direction side : EnumUtils.DIRECTIONS) {
            ConnectionType connectionType = this.getTransmitter().getConnectionType(side);
            if (connectionType == ConnectionType.NONE) continue;
            if (isSmall) {
                list.add(BlockSmallTransmitter.getSideForType(connectionType, side));
                continue;
            }
            list.add(BlockLargeTransmitter.getSideForType(connectionType, side));
        }
        list.add(isSmall ? BlockSmallTransmitter.center : BlockLargeTransmitter.center);
        return list;
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1));
    }

    @Nonnull
    public IModelData getModelData() {
        TransmitterModelData data = this.initModelData();
        this.updateModelData(data);
        return new ModelDataMap.Builder().withInitial(TRANSMITTER_PROPERTY, (Object)data).build();
    }

    protected void updateModelData(TransmitterModelData modelData) {
        for (Direction side : EnumUtils.DIRECTIONS) {
            modelData.setConnectionData(side, this.getTransmitter().getConnectionType(side));
        }
    }

    @Nonnull
    protected TransmitterModelData initModelData() {
        return new TransmitterModelData();
    }

    @Override
    public void onAlloyInteraction(PlayerEntity player, Hand hand, ItemStack stack, @Nonnull AlloyTier tier) {
        if (this.func_145831_w() != null && this.getTransmitter().hasTransmitterNetwork()) {
            Object transmitterNetwork = this.getTransmitter().getTransmitterNetwork();
            ArrayList list = new ArrayList(((DynamicNetwork)transmitterNetwork).getTransmitters());
            list.sort((o1, o2) -> {
                if (o1 != null && o2 != null) {
                    return Double.compare(o1.getTilePos().func_177951_i((Vector3i)this.field_174879_c), o2.getTilePos().func_177951_i((Vector3i)this.field_174879_c));
                }
                return 0;
            });
            boolean sharesSet = false;
            int upgraded = 0;
            for (Transmitter transmitter : list) {
                BlockState upgradeState;
                TileEntityTransmitter transmitterTile;
                BlockState state;
                IUpgradeableTransmitter upgradeableTransmitter;
                if (!(transmitter instanceof IUpgradeableTransmitter) || !(upgradeableTransmitter = (IUpgradeableTransmitter)((Object)transmitter)).canUpgrade(tier) || (state = (transmitterTile = transmitter.getTransmitterTile()).func_195044_w()) == (upgradeState = transmitterTile.upgradeResult(state, tier.getBaseTier()))) continue;
                if (!sharesSet) {
                    if (transmitterNetwork instanceof DynamicBufferedNetwork) {
                        ((DynamicBufferedNetwork)transmitterNetwork).validateSaveShares((BufferedTransmitter)transmitter);
                    }
                    sharesSet = true;
                }
                transmitter.startUpgrading();
                Object upgradeData = upgradeableTransmitter.getUpgradeData();
                BlockPos transmitterPos = transmitter.getTilePos();
                World transmitterWorld = transmitter.getTileWorld();
                if (upgradeData == null) {
                    Mekanism.logger.warn("Got no upgrade data for transmitter at position: {} in {} but it said it would be able to provide some.", (Object)transmitterPos, (Object)transmitterWorld);
                    continue;
                }
                transmitterWorld.func_175656_a(transmitterPos, upgradeState);
                TileEntityTransmitter upgradedTile = WorldUtils.getTileEntity(TileEntityTransmitter.class, (IBlockReader)transmitterWorld, transmitterPos);
                if (upgradedTile == null) {
                    Mekanism.logger.warn("Error upgrading transmitter at position: {} in {}.", (Object)transmitterPos, (Object)transmitterWorld);
                    continue;
                }
                Transmitter<?, ?, ?> upgradedTransmitter = upgradedTile.getTransmitter();
                if (upgradedTransmitter instanceof IUpgradeableTransmitter) {
                    this.transferUpgradeData((IUpgradeableTransmitter)((Object)upgradedTransmitter), (TransmitterUpgradeData)upgradeData);
                } else {
                    Mekanism.logger.warn("Unhandled upgrade data.", (Throwable)new IllegalStateException());
                }
                if (++upgraded != 8) continue;
                break;
            }
            if (upgraded > 0) {
                ((DynamicNetwork)transmitterNetwork).invalidate(null);
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
            }
        }
    }

    private <DATA extends TransmitterUpgradeData> void transferUpgradeData(IUpgradeableTransmitter<DATA> upgradeableTransmitter, TransmitterUpgradeData data) {
        if (upgradeableTransmitter.dataTypeMatches(data)) {
            upgradeableTransmitter.parseUpgradeData(data);
        } else {
            Mekanism.logger.warn("Unhandled upgrade data.", (Throwable)new IllegalStateException());
        }
    }

    @Nonnull
    protected BlockState upgradeResult(@Nonnull BlockState current, @Nonnull BaseTier tier) {
        return current;
    }

    public void sideChanged(@Nonnull Direction side, @Nonnull ConnectionType old, @Nonnull ConnectionType type) {
    }

    protected DynamicHandler.InteractPredicate getExtractPredicate() {
        return (tank, side) -> {
            if (side == null) {
                return true;
            }
            ConnectionType connectionType = this.getTransmitter().getConnectionType(side);
            return connectionType == ConnectionType.NORMAL || connectionType == ConnectionType.PUSH;
        };
    }

    protected DynamicHandler.InteractPredicate getInsertPredicate() {
        return (tank, side) -> {
            if (side == null) {
                return true;
            }
            ConnectionType connectionType = this.getTransmitter().getConnectionType(side);
            return connectionType == ConnectionType.NORMAL || connectionType == ConnectionType.PULL;
        };
    }
}

