/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature.tree;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.util.biome.GeneratorUtil;
import biomesoplenty.common.util.block.IBlockPosQuery;
import biomesoplenty.common.world.gen.feature.tree.TreeFeatureBase;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.AbstractTopPlantBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraftforge.common.IPlantable;

public class CypressTreeFeature
extends TreeFeatureBase {
    private int trunkWidth = 1;

    protected CypressTreeFeature(IBlockPosQuery placeOn, IBlockPosQuery replace, BlockState log, BlockState leaves, BlockState altLeaves, BlockState vine, BlockState hanging, BlockState trunkFruit, int minHeight, int maxHeight, int trunkWidth) {
        super(placeOn, replace, log, leaves, altLeaves, vine, hanging, trunkFruit, minHeight, maxHeight);
        this.trunkWidth = trunkWidth;
    }

    public boolean checkSpace(IWorld world, BlockPos pos, int baseHeight, int height) {
        for (int y = 0; y <= height; ++y) {
            int radius = this.trunkWidth - 1;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos1 = pos.func_177982_a(x, y, z);
                    if (pos1.func_177956_o() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        BlockPos pos2 = pos.func_177982_a(0, height - 2, 0);
        return world.func_180495_p(pos2).canBeReplacedByLeaves((IWorldReader)world, pos2);
    }

    public void generateLeafLayer(IWorld world, Random rand, BlockPos pos, int leavesRadius, Set<BlockPos> changedLeaves, MutableBoundingBox boundingBox) {
        int start = -leavesRadius;
        int end = leavesRadius;
        for (int x = start; x <= end; ++x) {
            for (int z = start; z <= end; ++z) {
                if (leavesRadius > 0 && (x == start || x == end) && (z == start || z == end) || leavesRadius > 0 && (x == start || x == end || z == start || z == end) && rand.nextDouble() < 0.2) continue;
                this.placeLeaves(world, pos.func_177982_a(x, 0, z), changedLeaves, boundingBox);
            }
        }
    }

    public void generateBranch(IWorld world, Random rand, BlockPos pos, Direction direction, int length, Set<BlockPos> changedLogs, Set<BlockPos> changedLeaves, MutableBoundingBox boundingBox) {
        Direction.Axis axis = direction.func_176740_k();
        Direction sideways = direction.func_176746_e();
        for (int i = 1; i <= length; ++i) {
            BlockPos pos1 = pos.func_177967_a(direction, i);
            int r = i == 1 || i == length ? 1 : 2;
            for (int j = -r; j <= r; ++j) {
                if (i >= length && rand.nextInt(2) != 0) continue;
                this.placeLeaves(world, pos1.func_177967_a(sideways, j), changedLeaves, boundingBox);
            }
            if (length - i <= 2) continue;
            this.placeLeaves(world, pos1.func_177984_a(), changedLeaves, boundingBox);
            this.placeLeaves(world, pos1.func_177984_a().func_177967_a(sideways, -1), changedLeaves, boundingBox);
            this.placeLeaves(world, pos1.func_177984_a().func_177967_a(sideways, 1), changedLeaves, boundingBox);
            this.placeLog(world, pos1, axis, changedLogs, boundingBox);
        }
    }

    @Override
    protected boolean place(Set<BlockPos> changedLogs, Set<BlockPos> changedLeaves, IWorld world, Random random, BlockPos startPos, MutableBoundingBox boundingBox) {
        int leavesHeight;
        while (startPos.func_177956_o() > 1 && this.replace.matches(world, startPos) || world.func_180495_p(startPos).func_185904_a() == Material.field_151584_j) {
            startPos = startPos.func_177977_b();
        }
        for (int x = 0; x <= this.trunkWidth - 1; ++x) {
            for (int z = 0; z <= this.trunkWidth - 1; ++z) {
                if (this.placeOn.matches(world, startPos.func_177982_a(x, 0, z))) continue;
                return false;
            }
        }
        int height = GeneratorUtil.nextIntBetween(random, this.minHeight, this.maxHeight);
        int baseHeight = GeneratorUtil.nextIntBetween(random, (int)((float)height * 0.6f), (int)((float)height * 0.4f));
        int baseLeavesHeight = leavesHeight = height - baseHeight;
        if (leavesHeight < 3) {
            return false;
        }
        leavesHeight = MathHelper.func_76125_a((int)leavesHeight, (int)3, (int)5);
        leavesHeight = MathHelper.func_76125_a((int)(leavesHeight + random.nextInt(3)), (int)0, (int)baseLeavesHeight);
        if (!this.checkSpace(world, startPos.func_177984_a(), baseHeight, height)) {
            return false;
        }
        BlockPos pos = startPos.func_177981_b(height);
        this.placeLeaves(world, pos, changedLeaves, boundingBox);
        pos.func_177977_b();
        for (int i = 0; i < leavesHeight; ++i) {
            int radius = 3;
            if (i == 0) {
                radius = 1;
            } else if (i <= 2) {
                radius = 2;
            }
            this.generateLeafLayer(world, random, pos, radius, changedLeaves, boundingBox);
            pos = pos.func_177977_b();
        }
        this.placeSpanishMoss(world, random, pos);
        int trunkRadius = this.trunkWidth - 1;
        for (int x = -trunkRadius; x <= trunkRadius; ++x) {
            for (int z = -trunkRadius; z <= trunkRadius; ++z) {
                int dist = Math.abs(x) + Math.abs(z);
                if (dist > trunkRadius) continue;
                int heightHere = height - 1;
                if (dist == 1) {
                    heightHere = (int)((double)height * (0.2 + random.nextDouble() * 0.15));
                }
                heightHere += random.nextInt(2);
                for (int y = 0; y < heightHere; ++y) {
                    BlockPos local = startPos.func_177982_a(x, y, z);
                    boolean air = world.func_180495_p(local).func_204520_s().func_206888_e();
                    this.placeLog(world, local, changedLogs, boundingBox);
                    if (x != 0 || z != 0 || !air || y >= heightHere - leavesHeight + 1) continue;
                    if (y >= baseHeight && random.nextInt(3) == 0) {
                        double theta = Math.PI * random.nextDouble() * 2.0;
                        int length = 2 + random.nextInt(3);
                        BlockPos branchPos = null;
                        for (int i = 0; i < length; ++i) {
                            branchPos = local.func_177963_a(Math.cos(theta) * (double)i, (double)(i / 2), Math.sin(theta) * (double)i);
                            this.placeLog(world, branchPos, changedLogs, boundingBox);
                        }
                        this.generateLeafLayer(world, random, branchPos, 2, changedLeaves, boundingBox);
                        this.generateLeafLayer(world, random, branchPos.func_177984_a(), 1, changedLeaves, boundingBox);
                        if (random.nextBoolean()) {
                            this.generateLeafLayer(world, random, branchPos.func_177981_b(2), 0, changedLeaves, boundingBox);
                        }
                        this.placeSpanishMoss(world, random, branchPos);
                        continue;
                    }
                    if (y < baseHeight || random.nextInt(3) != 0) continue;
                    Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(random);
                    BlockPos offset = local.func_177972_a(direction);
                    this.placeLog(world, offset, changedLogs, boundingBox);
                    for (Direction dir : Direction.values()) {
                        if (!(random.nextDouble() > 0.2)) continue;
                        this.placeLeaves(world, offset.func_177972_a(dir), changedLeaves, boundingBox);
                    }
                    this.placeSpanishMoss(world, random, offset);
                }
            }
        }
        return true;
    }

    @Override
    public boolean placeLeaves(IWorld world, BlockPos pos, Set<BlockPos> changedBlocks, MutableBoundingBox boundingBox) {
        if (world.func_180495_p(pos).canBeReplacedByLeaves((IWorldReader)world, pos)) {
            this.func_230367_a_((IWorldWriter)world, pos, this.leaves);
            this.placeBlock(world, pos, this.leaves, changedBlocks, boundingBox);
            return true;
        }
        return false;
    }

    private void placeSpanishMoss(IWorld p_236429_1_, Random p_236429_2_, BlockPos p_236429_3_) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int i = 0; i < 50; ++i) {
            BlockState blockstate;
            blockpos$mutable.func_239621_a_((Vector3i)p_236429_3_, p_236429_2_.nextInt(5) - p_236429_2_.nextInt(5), p_236429_2_.nextInt(3) - p_236429_2_.nextInt(3), p_236429_2_.nextInt(5) - p_236429_2_.nextInt(5));
            if (!p_236429_1_.func_175623_d((BlockPos)blockpos$mutable) || (blockstate = p_236429_1_.func_180495_p(blockpos$mutable.func_177984_a())).func_177230_c() != BOPBlocks.willow_leaves) continue;
            int j = MathHelper.func_76136_a((Random)p_236429_2_, (int)1, (int)3);
            if (p_236429_2_.nextInt(5) == 0) {
                j = 1;
            }
            CypressTreeFeature.placeSpanishMossColumn(p_236429_1_, p_236429_2_, blockpos$mutable, j, 17, 25);
        }
    }

    public static void placeSpanishMossColumn(IWorld p_236427_0_, Random p_236427_1_, BlockPos.Mutable p_236427_2_, int p_236427_3_, int p_236427_4_, int p_236427_5_) {
        for (int i = 0; i <= p_236427_3_; ++i) {
            if (p_236427_0_.func_175623_d((BlockPos)p_236427_2_)) {
                if (i == p_236427_3_ || !p_236427_0_.func_175623_d(p_236427_2_.func_177977_b())) {
                    p_236427_0_.func_180501_a((BlockPos)p_236427_2_, (BlockState)BOPBlocks.spanish_moss.func_176223_P().func_206870_a((Property)AbstractTopPlantBlock.field_235502_d_, (Comparable)Integer.valueOf(MathHelper.func_76136_a((Random)p_236427_1_, (int)p_236427_4_, (int)p_236427_5_))), 2);
                    break;
                }
                p_236427_0_.func_180501_a((BlockPos)p_236427_2_, BOPBlocks.spanish_moss_plant.func_176223_P(), 2);
            }
            p_236427_2_.func_189536_c(Direction.DOWN);
        }
    }

    public static class Builder
    extends TreeFeatureBase.BuilderBase<Builder, CypressTreeFeature> {
        protected int trunkWidth;

        public Builder trunkWidth(int a) {
            this.trunkWidth = a;
            return this;
        }

        public Builder() {
            this.minHeight = 6;
            this.maxHeight = 15;
            this.placeOn = (world, pos) -> world.func_180495_p(pos).canSustainPlant((IBlockReader)world, pos, Direction.UP, (IPlantable)((SaplingBlock)Blocks.field_196674_t));
            this.replace = (world, pos) -> world.func_180495_p(pos).canBeReplacedByLeaves((IWorldReader)world, pos) || world.func_180495_p(pos).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos).func_177230_c().func_203417_a((ITag)BlockTags.field_200030_g) || world.func_180495_p(pos).func_177230_c() == Blocks.field_150395_bd || world.func_180495_p(pos).func_177230_c() == BOPBlocks.willow_vine || world.func_180495_p(pos).func_177230_c() == BOPBlocks.spanish_moss_plant || world.func_180495_p(pos).func_177230_c() == BOPBlocks.spanish_moss || world.func_180495_p(pos).func_177230_c() instanceof BushBlock;
            this.log = BOPBlocks.willow_log.func_176223_P();
            this.leaves = BOPBlocks.willow_leaves.func_176223_P();
            this.vine = BOPBlocks.willow_vine.func_176223_P();
            this.trunkWidth = 1;
        }

        @Override
        public CypressTreeFeature create() {
            return new CypressTreeFeature(this.placeOn, this.replace, this.log, this.leaves, this.altLeaves, this.vine, this.hanging, this.trunkFruit, this.minHeight, this.maxHeight, this.trunkWidth);
        }
    }
}

