/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Unit;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.MultipartBakedModel;
import net.minecraft.client.renderer.model.WeightedBakedModel;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IRegistryDelegate;
import org.apache.commons.lang3.tuple.Pair;
import team.chisel.ctm.client.model.AbstractCTMBakedModel;
import team.chisel.ctm.client.util.ResourceUtil;
import team.chisel.ctm.client.util.TextureMetadataHandler;

public class CTMPackReloadListener
extends ReloadListener<Unit> {
    private static final Map<IRegistryDelegate<Block>, Predicate<RenderType>> blockRenderChecks = Maps.newHashMap();
    private static final Field _blockRenderChecks = ObfuscationReflectionHelper.findField(RenderTypeLookup.class, (String)"blockRenderChecks");
    private static final MethodHandle _fancyGraphics;

    @SubscribeEvent
    public void onParticleFactoryRegister(ParticleFactoryRegisterEvent event) {
        ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)this);
    }

    protected Unit prepare(IResourceManager resourceManagerIn, IProfiler profilerIn) {
        return Unit.INSTANCE;
    }

    protected void apply(Unit objectIn, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        ResourceUtil.invalidateCaches();
        TextureMetadataHandler.INSTANCE.invalidateCaches();
        AbstractCTMBakedModel.invalidateCaches();
        this.refreshLayerHacks();
    }

    private void refreshLayerHacks() {
        blockRenderChecks.forEach((b, p) -> RenderTypeLookup.setRenderLayer((Block)((Block)b.get()), (Predicate)p));
        blockRenderChecks.clear();
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            BlockState state = block.func_176223_P();
            Predicate<RenderType> predicate = this.getLayerCheck(state, Minecraft.func_71410_x().func_209506_al().func_174954_c().func_178125_b(state));
            if (predicate == null) continue;
            blockRenderChecks.put((IRegistryDelegate<Block>)block.delegate, this.getExistingRenderCheck(block));
            RenderTypeLookup.setRenderLayer((Block)block, predicate);
        }
    }

    private Predicate<RenderType> getLayerCheck(BlockState state, IBakedModel model) {
        if (model instanceof AbstractCTMBakedModel) {
            return layer -> ((AbstractCTMBakedModel)model).getModel().canRenderInLayer(state, (RenderType)layer);
        }
        if (model instanceof WeightedBakedModel) {
            return CachingLayerCheck.of(state, ((WeightedBakedModel)model).field_177565_b, wm -> wm.field_185281_b);
        }
        if (model instanceof MultipartBakedModel) {
            return CachingLayerCheck.of(state, ((MultipartBakedModel)model).field_188626_f, Pair::getRight);
        }
        return null;
    }

    private Predicate<RenderType> getExistingRenderCheck(Block block) {
        try {
            return (Predicate)((Map)_blockRenderChecks.get(null)).get(block.delegate);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canRenderInLayerFallback(BlockState state, RenderType type) {
        Block block = state.func_177230_c();
        if (block instanceof LeavesBlock) {
            try {
                return _fancyGraphics.invokeExact() ? type == RenderType.func_228641_d_() : type == RenderType.func_228639_c_();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        Class<RenderTypeLookup> clazz = RenderTypeLookup.class;
        synchronized (RenderTypeLookup.class) {
            Predicate<RenderType> rendertype = blockRenderChecks.get(block.delegate);
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return rendertype != null ? rendertype.test(type) : type == RenderType.func_228639_c_();
        }
    }

    static {
        try {
            _fancyGraphics = MethodHandles.lookup().unreflectGetter(ObfuscationReflectionHelper.findField(RenderTypeLookup.class, (String)"field_228388_c_"));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static class CachingLayerCheck
    implements Predicate<RenderType> {
        private final BlockState state;
        private final List<AbstractCTMBakedModel> models;
        private final boolean useFallback;
        private final Object2BooleanMap<RenderType> cache = new Object2BooleanOpenHashMap();

        static <T> CachingLayerCheck of(BlockState state, Collection<T> rawModels, Function<T, IBakedModel> converter) {
            List<AbstractCTMBakedModel> ctmModels;
            return new CachingLayerCheck(state, ctmModels, (ctmModels = rawModels.stream().map(converter).filter(m -> m instanceof AbstractCTMBakedModel).map(m -> (AbstractCTMBakedModel)m).collect(Collectors.toList())).size() < rawModels.size());
        }

        @Override
        public boolean test(RenderType layer) {
            return this.cache.computeBooleanIfAbsent((Object)layer, type -> this.models.stream().anyMatch(m -> m.getModel().canRenderInLayer(this.state, (RenderType)type)) || this.useFallback && CTMPackReloadListener.canRenderInLayerFallback(this.state, layer));
        }

        public CachingLayerCheck(BlockState state, List<AbstractCTMBakedModel> models, boolean useFallback) {
            this.state = state;
            this.models = models;
            this.useFallback = useFallback;
        }
    }
}

