/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.map;

import dev.ftb.mods.ftbchunks.ColorMapLoader;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.client.map.MapRegion;
import dev.ftb.mods.ftbchunks.core.BlockStateFTBC;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.IChunk;
import org.jetbrains.annotations.Nullable;

public class MapChunk {
    public final MapRegion region;
    public final XZ pos;
    public long modified;
    public ClientTeam team;
    public Date claimedDate;
    public Date forceLoadedDate;

    public MapChunk(MapRegion r, XZ p) {
        this.region = r;
        this.pos = p;
        this.modified = 0L;
        this.team = null;
        this.claimedDate = null;
        this.forceLoadedDate = null;
    }

    @Nullable
    public ClientTeam getTeam() {
        if (this.team != null && this.team.invalid) {
            this.team = this.team.manager.getTeam(this.team.getId());
        }
        return this.team;
    }

    public boolean connects(MapChunk chunk) {
        return Objects.equals(this.getTeam(), chunk.getTeam());
    }

    public XZ getActualPos() {
        return XZ.of((int)((this.region.pos.x << 5) + this.pos.x), (int)((this.region.pos.z << 5) + this.pos.z));
    }

    public static boolean isWater(BlockState state) {
        if (state.func_177230_c() == Blocks.field_150355_j) {
            return true;
        }
        return state instanceof BlockStateFTBC ? ((BlockStateFTBC)state).getFTBCIsWater() : state.func_204520_s().func_206886_c().func_207187_a((Fluid)Fluids.field_204546_a);
    }

    public static boolean skipBlock(BlockState state) {
        if (state.func_196958_f()) {
            return true;
        }
        ResourceLocation id = FTBChunks.BLOCK_REGISTRY.getId((Object)state.func_177230_c());
        return id == null || ColorMapLoader.getBlockColor(id).isIgnored();
    }

    public static BlockPos.Mutable getHeight(@Nullable IChunk chunk, BlockPos.Mutable pos, boolean[] flags) {
        int topY = pos.func_177956_o();
        if (topY == -1) {
            pos.func_185336_p(-1);
            return pos;
        }
        for (int by = topY; by > 0; --by) {
            pos.func_185336_p(by);
            BlockState state = chunk.func_180495_p((BlockPos)pos);
            if (by == topY || state.func_177230_c() == Blocks.field_150357_h) {
                while (by > 0) {
                    pos.func_185336_p(by);
                    state = chunk.func_180495_p((BlockPos)pos);
                    if (state.func_196958_f()) break;
                    --by;
                }
            }
            boolean water = MapChunk.isWater(state);
            flags[0] = flags[0] | water;
            if (water || MapChunk.skipBlock(state)) continue;
            pos.func_185336_p(by);
            return pos;
        }
        pos.func_185336_p(-1);
        return pos;
    }

    public MapChunk created() {
        this.region.update(true);
        return this;
    }

    public MapChunk offsetBlocking(int x, int z) {
        XZ pos = this.getActualPos().offset(x, z);
        return this.region.dimension.getRegion(XZ.regionFromChunk((int)pos.x, (int)pos.z)).getDataBlocking().getChunk(pos);
    }

    public void updateFrom(Date now, SendChunkPacket.SingleChunk packet, UUID t) {
        this.team = (ClientTeam)ClientTeamManager.INSTANCE.teamMap.get(t);
        this.claimedDate = this.team == null ? null : new Date(now.getTime() - packet.relativeTimeClaimed);
        this.forceLoadedDate = packet.forceLoaded && this.claimedDate != null ? new Date(now.getTime() - packet.relativeTimeForceLoaded) : null;
        this.region.update(false);
    }
}

