/*
 * Decompiled with CFR 0.152.
 */
package com.mcwfurnitures.kikoz.objects.mirror;

import com.mcwfurnitures.kikoz.objects.multiple.DoubleFurniture;
import com.mcwfurnitures.kikoz.storage.FurnitureTileEntityDouble;
import com.mcwfurnitures.kikoz.util.parts.DoubleTallPart;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class DoubleFurnitureMirror
extends DoubleFurniture
implements IWaterLoggable {
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.field_208142_aq;
    private static final EnumProperty<DoubleTallPart> PART = EnumProperty.func_177709_a((String)"part", DoubleTallPart.class);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private static final Map<Direction, VoxelShape> FURNITURE_MIDDLE = new HashMap<Direction, VoxelShape>();
    private static final Map<Direction, VoxelShape> FURNITURE_BOTTOM = new HashMap<Direction, VoxelShape>();
    String infoname;
    boolean hasTextInfo = true;

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        DoubleTallPart part = (DoubleTallPart)((Object)state.func_177229_b(PART));
        if (part == DoubleTallPart.BOTTOM) {
            return FURNITURE_BOTTOM.get(state.func_177229_b((Property)FACING));
        }
        if (part == DoubleTallPart.MIDDLE) {
            return FURNITURE_MIDDLE.get(state.func_177229_b((Property)FACING));
        }
        return FURNITURE_MIDDLE.get(state.func_177229_b((Property)FACING));
    }

    @Override
    public void place(World world, BlockPos pos, Direction direction) {
        BlockState state = (BlockState)((BlockState)this.func_176223_P().func_206870_a(PART, (Comparable)((Object)DoubleTallPart.BOTTOM))).func_206870_a((Property)FACING, (Comparable)direction);
        world.func_180501_a(pos, state, 3);
        this.place(world, pos, state, direction.func_176734_d());
    }

    @Override
    public void place(World world, BlockPos pos, BlockState state, Direction direction) {
        FluidState middleFluidState = world.func_204610_c(pos.func_177984_a());
        world.func_180501_a(pos.func_177984_a(), (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)DoubleTallPart.MIDDLE))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(middleFluidState.func_206886_c() == Fluids.field_204546_a)), 3);
    }

    @Override
    public void remove(World world, BlockPos pos, BlockState state) {
        BlockPos FurniturePartPos;
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        BlockPos FurniturePos = this.getFurniturePos(pos, (DoubleTallPart)((Object)state.func_177229_b(PART)), facing);
        BlockState FurnitureBlockState = world.func_180495_p(FurniturePos);
        if (FurnitureBlockState.func_177230_c() == this && !pos.equals((Object)FurniturePos)) {
            this.removePart(world, FurniturePos, FurnitureBlockState);
        }
        if ((FurnitureBlockState = world.func_180495_p(FurniturePartPos = this.getFurnitureMiddlePos(FurniturePos, facing))).func_177230_c() == this && !pos.equals((Object)FurniturePartPos)) {
            this.removePart(world, FurniturePartPos, FurnitureBlockState);
        }
        if ((FurnitureBlockState = world.func_180495_p(FurniturePartPos = this.getFurnitureMiddlePos(FurniturePos, facing))).func_177230_c() == this && !pos.equals((Object)FurniturePartPos)) {
            this.removePart(world, FurniturePartPos, FurnitureBlockState);
        }
    }

    private BlockPos getFurnitureMiddlePos(BlockPos base, Direction facing) {
        switch (facing) {
            case NORTH: {
                return base.func_177984_a();
            }
            case EAST: {
                return base.func_177984_a();
            }
            case SOUTH: {
                return base.func_177984_a();
            }
            case WEST: {
                return base.func_177984_a();
            }
        }
        return base.func_177984_a();
    }

    private BlockPos getFurniturePos(BlockPos pos, DoubleTallPart part, Direction facing) {
        if (part == DoubleTallPart.BOTTOM) {
            return pos;
        }
        switch (facing) {
            case NORTH: {
                switch (part) {
                    case MIDDLE: {
                        return pos.func_177977_b();
                    }
                }
                return null;
            }
            case EAST: {
                switch (part) {
                    case MIDDLE: {
                        return pos.func_177977_b();
                    }
                }
                return null;
            }
            case SOUTH: {
                switch (part) {
                    case MIDDLE: {
                        return pos.func_177977_b();
                    }
                }
                return null;
            }
            case WEST: {
                switch (part) {
                    case MIDDLE: {
                        return pos.func_177977_b();
                    }
                }
                return null;
            }
        }
        return null;
    }

    private void removePart(World world, BlockPos pos, BlockState state) {
        FluidState fluidState = world.func_204610_c(pos);
        if (fluidState.func_206886_c() == Fluids.field_204546_a) {
            world.func_180501_a(pos, fluidState.func_206883_i(), 35);
        } else {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 35);
        }
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        BlockPos pos = context.func_195995_a();
        BlockPos FurnitureMiddlePos = this.getFurnitureMiddlePos(pos, context.func_195992_f().func_176734_d());
        if (pos.func_177956_o() < 255 && FurnitureMiddlePos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(pos.func_177984_a()).func_196953_a(context)) {
            return (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a(PART, (Comparable)((Object)DoubleTallPart.BOTTOM))).func_206870_a(HINGE, (Comparable)this.getHingeSide(context))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206884_a((ITag)FluidTags.field_206959_a) && ifluidstate.func_206882_g() == 8));
        }
        return null;
    }

    private DoorHingeSide getHingeSide(BlockItemUseContext context) {
        boolean flag1;
        World iblockreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        Direction direction = context.func_195992_f();
        BlockPos blockpos1 = blockpos.func_177984_a();
        Direction direction1 = direction.func_176735_f();
        BlockPos blockpos2 = blockpos.func_177972_a(direction1);
        BlockState blockstate = iblockreader.func_180495_p(blockpos2);
        BlockPos blockpos3 = blockpos1.func_177972_a(direction1);
        BlockState blockstate1 = iblockreader.func_180495_p(blockpos3);
        Direction direction2 = direction.func_176746_e();
        BlockPos blockpos4 = blockpos.func_177972_a(direction2);
        BlockState blockstate2 = iblockreader.func_180495_p(blockpos4);
        BlockPos blockpos5 = blockpos1.func_177972_a(direction2);
        BlockState blockstate3 = iblockreader.func_180495_p(blockpos5);
        int i = (blockstate.func_235785_r_((IBlockReader)iblockreader, blockpos2) ? -1 : 0) + (blockstate1.func_235785_r_((IBlockReader)iblockreader, blockpos3) ? -1 : 0) + (blockstate2.func_235785_r_((IBlockReader)iblockreader, blockpos4) ? 1 : 0) + (blockstate3.func_235785_r_((IBlockReader)iblockreader, blockpos5) ? 1 : 0);
        boolean flag = blockstate.func_203425_a((Block)this) && blockstate.func_177229_b(PART) == DoubleTallPart.BOTTOM;
        boolean bl = flag1 = blockstate2.func_203425_a((Block)this) && blockstate2.func_177229_b(PART) == DoubleTallPart.MIDDLE;
        if ((!flag || flag1) && i <= 0) {
            if ((!flag1 || flag) && i >= 0) {
                int j = direction.func_82601_c();
                int k = direction.func_82599_e();
                Vector3d vector3d = context.func_221532_j();
                double d0 = vector3d.field_72450_a - (double)blockpos.func_177958_n();
                double d1 = vector3d.field_72449_c - (double)blockpos.func_177952_p();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : (BlockState)state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING))).func_235896_a_(HINGE);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PART, FACING, WATERLOGGED, HINGE});
    }

    public DoubleFurnitureMirror() {
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(HINGE, (Comparable)DoorHingeSide.LEFT)).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a(PART, (Comparable)((Object)DoubleTallPart.BOTTOM)));
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult result) {
        if (!worldIn.field_72995_K) {
            TileEntity tile = worldIn.func_175625_s(pos);
            TileEntity tilenorth = worldIn.func_175625_s(pos.func_177979_c(1));
            DoubleTallPart part = (DoubleTallPart)((Object)state.func_177229_b(PART));
            if (tile instanceof FurnitureTileEntityDouble) {
                if (part == DoubleTallPart.BOTTOM) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((FurnitureTileEntityDouble)tile), (BlockPos)pos);
                    return ActionResultType.SUCCESS;
                }
                if (part == DoubleTallPart.MIDDLE) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((FurnitureTileEntityDouble)tilenorth), (BlockPos)pos);
                    return ActionResultType.SUCCESS;
                }
            }
        }
        return ActionResultType.FAIL;
    }

    static {
        FURNITURE_MIDDLE.put(Direction.NORTH, Stream.of(Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_MIDDLE.put(Direction.EAST, Stream.of(Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_MIDDLE.put(Direction.SOUTH, Stream.of(Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_MIDDLE.put(Direction.WEST, Stream.of(Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_BOTTOM.put(Direction.NORTH, Stream.of(Block.func_208617_a((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_BOTTOM.put(Direction.EAST, Stream.of(Block.func_208617_a((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_BOTTOM.put(Direction.SOUTH, Stream.of(Block.func_208617_a((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_BOTTOM.put(Direction.WEST, Stream.of(Block.func_208617_a((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
    }
}

