/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.internal.network;

import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.data.nbt.NBTHelper;
import it.zerono.mods.zerocore.lib.network.AbstractModTileMessage;
import java.util.Objects;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;

public class TileCommandMessage
extends AbstractModTileMessage {
    private final String _name;
    private final CompoundNBT _parameters;

    public static TileCommandMessage create(AbstractModBlockEntity tile, String commandName) {
        return TileCommandMessage.create(tile, commandName, NBTHelper.EMPTY_COMPOUND);
    }

    public static TileCommandMessage create(AbstractModBlockEntity tile, String commandName, CompoundNBT parameters) {
        return new TileCommandMessage(tile, commandName, parameters);
    }

    public TileCommandMessage(PacketBuffer buffer) {
        super(buffer);
        this._name = buffer.func_150789_c(4096);
        this._parameters = buffer.readBoolean() ? buffer.func_150793_b() : NBTHelper.EMPTY_COMPOUND;
    }

    @Override
    public void encodeTo(PacketBuffer buffer) {
        super.encodeTo(buffer);
        buffer.func_180714_a(this._name);
        if (this._parameters.isEmpty()) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.func_150786_a(this._parameters);
        }
    }

    @Override
    protected void processTileEntityMessage(LogicalSide sourceSide, TileEntity tileEntity) {
        if (tileEntity instanceof AbstractModBlockEntity) {
            ((AbstractModBlockEntity)tileEntity).handleCommand(sourceSide, this._name, this._parameters);
        } else {
            Log.LOGGER.error(Log.NETWORK, "No command-aware Tile Entity found while processing a command message: skipping");
        }
    }

    protected TileCommandMessage(AbstractModBlockEntity tile, String commandName, CompoundNBT parameters) {
        super(tile.func_174877_v(), (RegistryKey<World>)Objects.requireNonNull(tile.func_145831_w()).func_234923_W_());
        this._name = commandName;
        this._parameters = parameters;
    }
}

