/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.render.vertexuploader;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.zerono.mods.zerocore.lib.client.render.IVertexSource;
import it.zerono.mods.zerocore.lib.client.render.vertexuploader.ISourceAdapter;
import it.zerono.mods.zerocore.lib.data.geometry.Vector3d;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.data.gfx.LightMap;
import javax.annotation.Nullable;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;

public class GenericAdapter
implements ISourceAdapter {
    private MatrixStack _matrix = null;
    private Colour _colour = null;
    private LightMap _light = null;
    private LightMap _overlay = null;

    public GenericAdapter setMatrix(@Nullable MatrixStack matrix) {
        this._matrix = matrix;
        return this;
    }

    public GenericAdapter setColour(@Nullable Colour colour) {
        this._colour = colour;
        return this;
    }

    public GenericAdapter setLight(@Nullable LightMap light) {
        this._light = light;
        return this;
    }

    public GenericAdapter setLight(int combined) {
        return this.setLight(new LightMap(combined));
    }

    public GenericAdapter setOverlay(@Nullable LightMap overlay) {
        this._overlay = overlay;
        return this;
    }

    public GenericAdapter setOverlay(int combined) {
        return this.setOverlay(new LightMap(combined));
    }

    @Override
    public Vector3d getPos(IVertexSource source) {
        if (null != this._matrix) {
            Vector3d original = source.getPos();
            Vector4f v = new Vector4f((float)original.X, (float)original.Y, (float)original.Y, 1.0f);
            v.func_229372_a_(this._matrix.func_227866_c_().func_227870_a_());
            return Vector3d.from(v);
        }
        return source.getPos();
    }

    @Override
    @Nullable
    public Vector3f getNormal(IVertexSource source) {
        Vector3f original = source.getNormal();
        if (null != this._matrix && null != original) {
            Vector3f v = original.func_229195_e_();
            v.func_229188_a_(this._matrix.func_227866_c_().func_227872_b_());
            return v;
        }
        return original;
    }

    @Override
    @Nullable
    public Colour getColour(IVertexSource source) {
        return null != this._colour ? this._colour : source.getColour();
    }

    @Override
    @Nullable
    public LightMap getLightMap(IVertexSource source) {
        return null != this._light ? this._light : source.getLightMap();
    }

    @Override
    @Nullable
    public LightMap getOverlayMap(IVertexSource source) {
        return null != this._overlay ? this._overlay : source.getOverlayMap();
    }
}

