/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.render.vertexuploader;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.client.render.IVertexSequence;
import it.zerono.mods.zerocore.lib.client.render.IVertexSource;
import it.zerono.mods.zerocore.lib.client.render.vertexuploader.ISourceAdapter;
import it.zerono.mods.zerocore.lib.client.render.vertexuploader.IUploader;
import it.zerono.mods.zerocore.lib.data.geometry.Vector3d;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.data.gfx.LightMap;
import it.zerono.mods.zerocore.lib.data.gfx.UV;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.math.vector.Vector3f;

public class VertexUploader {
    public static final VertexUploader INSTANCE = new VertexUploader();
    private static final ISourceAdapter DEFAULT_ADAPTER = new ISourceAdapter(){};
    private final Map<VertexFormat, IUploader> _uploaders = Maps.newHashMapWithExpectedSize((int)2);

    public void upload(IVertexBuilder builder, IVertexSource source) {
        this.upload(builder, source, DEFAULT_ADAPTER);
    }

    public void upload(IVertexBuilder builder, IVertexSequence sequence) {
        this.upload(builder, sequence, DEFAULT_ADAPTER);
    }

    public void upload(IVertexBuilder builder, List<IVertexSource> sources) {
        this.upload(builder, sources, DEFAULT_ADAPTER);
    }

    public void upload(IVertexBuilder builder, IVertexSource source, ISourceAdapter adapter) {
        this.getUploaderFor(builder).upload(builder, source, adapter);
    }

    public void upload(IVertexBuilder builder, IVertexSequence sequence, ISourceAdapter adapter) {
        this.upload(builder, sequence.getVertices(), adapter);
    }

    public void upload(IVertexBuilder builder, List<IVertexSource> sources, ISourceAdapter adapter) {
        IUploader uploader = this.getUploaderFor(builder);
        sources.forEach(source -> uploader.upload(builder, (IVertexSource)source, adapter));
    }

    private VertexUploader() {
        this._uploaders.put(DefaultVertexFormats.field_176600_a, VertexUploader::blockUploader);
        this._uploaders.put(DefaultVertexFormats.field_227849_i_, VertexUploader::entityUploader);
    }

    private IUploader getUploaderFor(IVertexBuilder builder) {
        if (builder instanceof BufferBuilder) {
            return this._uploaders.getOrDefault(((BufferBuilder)builder).getVertexFormat(), VertexUploader::fallBackUploader);
        }
        return VertexUploader::fallBackUploader;
    }

    private static void fallBackUploader(IVertexBuilder builder, IVertexSource source, ISourceAdapter adapter) {
        Vector3d pos = adapter.getPos(source);
        Vector3f normal = adapter.getNormal(source);
        UV uv = adapter.getUV(source);
        Colour colour = adapter.getColour(source);
        LightMap overlay = adapter.getOverlayMap(source);
        LightMap light = adapter.getLightMap(source);
        builder.func_225582_a_(pos.X, pos.Y, pos.Z);
        if (null != colour) {
            builder.func_225586_a_((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A);
        }
        if (null != uv) {
            builder.func_225583_a_(uv.U, uv.V);
        }
        if (null != overlay) {
            builder.func_225585_a_(overlay.U, overlay.V);
        }
        if (null != light) {
            builder.func_225587_b_(light.U, light.V);
        }
        if (null != normal) {
            builder.func_225584_a_(normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c());
        }
        builder.func_181675_d();
    }

    private static void blockUploader(IVertexBuilder builder, IVertexSource source, ISourceAdapter adapter) {
        Vector3d pos = adapter.getPos(source);
        Vector3f normal = adapter.getNormal(source);
        UV uv = adapter.getUV(source);
        Colour colour = adapter.getColour(source);
        LightMap light = adapter.getLightMap(source);
        builder.func_225582_a_(pos.X, pos.Y, pos.Z).func_225586_a_((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A).func_225583_a_(uv.U, uv.V).func_225587_b_(light.U, light.V).func_225584_a_(normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c()).func_181675_d();
    }

    private static void entityUploader(IVertexBuilder builder, IVertexSource source, ISourceAdapter adapter) {
        Vector3d pos = adapter.getPos(source);
        Vector3f normal = adapter.getNormal(source);
        UV uv = adapter.getUV(source);
        Colour colour = adapter.getColour(source);
        LightMap overlay = adapter.getOverlayMap(source);
        LightMap light = adapter.getLightMap(source);
        Log.LOGGER.info("UPV {}", (Object)source);
        builder.func_225582_a_(pos.X, pos.Y, pos.Z).func_225586_a_((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A).func_225583_a_(uv.U, uv.V).func_225585_a_(overlay.U, overlay.V).func_225587_b_(light.U, light.V).func_225584_a_(normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c()).func_181675_d();
    }
}

