/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.compat.patchouli;

import com.google.common.collect.Maps;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.compat.Mods;
import it.zerono.mods.zerocore.lib.compat.patchouli.component.standardpage.Crafting;
import it.zerono.mods.zerocore.lib.compat.patchouli.component.standardpage.Multiblock;
import it.zerono.mods.zerocore.lib.compat.patchouli.component.standardpage.Smelting;
import it.zerono.mods.zerocore.lib.compat.patchouli.component.standardpage.Spotlight;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.util.NonNullSupplier;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.template.BookTemplate;

public class Patchouli {
    private static boolean s_init = false;
    private static final Map<IMultiblock, Function<BlockState, BlockState>> s_renderBlockStateMappers = Maps.newHashMap();
    private static final Map<IMultiblock, Function<BlockState, IModelData>> s_modelDataMappers = Maps.newHashMap();

    public static void registerMultiblock(ResourceLocation id, IMultiblock multiblock, Function<BlockState, BlockState> renderBlockStateMappers, Function<BlockState, IModelData> modelDataMapper) {
        PatchouliAPI.get().registerMultiblock(id, multiblock);
        s_renderBlockStateMappers.put(multiblock, renderBlockStateMappers);
        s_modelDataMappers.put(multiblock, modelDataMapper);
    }

    public static BlockState getRenderBlockStateFor(IMultiblock multiblock, BlockState blockState) {
        return s_renderBlockStateMappers.getOrDefault(multiblock, bs -> bs).apply(blockState);
    }

    public static IModelData getModelDataFor(IMultiblock multiblock, BlockState blockState) {
        return s_modelDataMappers.getOrDefault(multiblock, b -> EmptyModelData.INSTANCE).apply(blockState);
    }

    public static void initialize() {
        Mods.PATCHOULI.ifPresent((NonNullSupplier<Runnable>)((NonNullSupplier)() -> () -> {
            if (s_init) {
                return;
            }
            Log.LOGGER.info("Initializing Patchouli custom templates...");
            BookTemplate.registerComponent((String)"zcsptMultiblock", Multiblock.class);
            BookTemplate.registerComponent((String)"zcsptSpotlight", Spotlight.class);
            BookTemplate.registerComponent((String)"zcsptCrafting", Crafting.class);
            BookTemplate.registerComponent((String)"zcsptSmelting", Smelting.class);
            s_init = true;
        }));
    }
}

