/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory;

import it.zerono.mods.zerocore.lib.DebuggableHelper;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.data.stack.AbstractStackHolder;
import it.zerono.mods.zerocore.lib.data.stack.IStackHolder;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemStackHolder
extends AbstractStackHolder<ItemStackHolder, ItemStack>
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<CompoundNBT>,
ISyncableEntity,
IDebuggable {
    protected NonNullList<ItemStack> _stacks;

    public ItemStackHolder(int size) {
        this((NonNullList<ItemStack>)NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a));
    }

    public ItemStackHolder(int size, BiPredicate<Integer, ItemStack> stackValidator) {
        this((NonNullList<ItemStack>)NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a), stackValidator);
    }

    public ItemStackHolder(NonNullList<ItemStack> stacks) {
        this._stacks = stacks;
    }

    public ItemStackHolder(NonNullList<ItemStack> stacks, BiPredicate<Integer, ItemStack> stackValidator) {
        super(stackValidator);
        this._stacks = stacks;
    }

    public void setSize(int size) {
        this._stacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
    }

    @Override
    public boolean isEmpty(int index) {
        return false;
    }

    public int getSlots() {
        return this._stacks.size();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return (ItemStack)this._stacks.get(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this._stacks.get(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                this._stacks.set(slot, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack));
                this.onChange(IStackHolder.ChangeType.Added, slot);
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
                this.onChange(IStackHolder.ChangeType.Grown, slot);
            }
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (0 == amount) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this._stacks.get(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this._stacks.set(slot, (Object)ItemStack.field_190927_a);
                this.onChange(IStackHolder.ChangeType.Removed, slot);
                return existing;
            }
            return existing.func_77946_l();
        }
        if (!simulate) {
            this._stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
            this.onChange(IStackHolder.ChangeType.Shrunk, slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.isStackValid(slot, stack);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.validateSlotIndex(slot);
        boolean wasEmpty = this.isEmpty(slot);
        boolean isNowEmpty = stack.func_190926_b();
        if (wasEmpty && isNowEmpty) {
            return;
        }
        this._stacks.set(slot, (Object)stack);
        this.onChange(wasEmpty ? IStackHolder.ChangeType.Added : (isNowEmpty ? IStackHolder.ChangeType.Removed : IStackHolder.ChangeType.Replaced), slot);
    }

    public CompoundNBT serializeNBT() {
        return this.syncDataTo(new CompoundNBT(), ISyncableEntity.SyncReason.FullSync);
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.syncDataFrom(nbt, ISyncableEntity.SyncReason.FullSync);
    }

    @Override
    public void syncDataFrom(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        this.setSize(data.func_150297_b("Size", 3) ? data.func_74762_e("Size") : this._stacks.size());
        ListNBT tagList = data.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT itemTags = tagList.func_150305_b(i);
            int slot = itemTags.func_74762_e("Slot");
            if (slot < 0 || slot >= this._stacks.size()) continue;
            this._stacks.set(slot, (Object)ItemStack.func_199557_a((CompoundNBT)itemTags));
        }
        this.onLoad();
    }

    @Override
    public CompoundNBT syncDataTo(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        ListNBT nbtTagList = new ListNBT();
        for (int i = 0; i < this._stacks.size(); ++i) {
            if (((ItemStack)this._stacks.get(i)).func_190926_b()) continue;
            CompoundNBT itemTag = new CompoundNBT();
            itemTag.func_74768_a("Slot", i);
            ((ItemStack)this._stacks.get(i)).func_77955_b(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        data.func_218657_a("Items", (INBT)nbtTagList);
        data.func_74768_a("Size", this._stacks.size());
        return data;
    }

    @Override
    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        DebuggableHelper.getDebugMessagesFor(messages, this);
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this._stacks.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this._stacks.size() + ")");
        }
    }

    protected int getStackLimit(int slot, ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.func_77976_d());
    }
}

