/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.handler;

import it.zerono.mods.zerocore.lib.item.inventory.handler.ItemHandlerModifiableForwarder;
import java.util.function.BiPredicate;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ItemHandlerPolicyWrapper {
    public static IItemHandlerModifiable twoWay(IItemHandlerModifiable original, BiPredicate<Integer, ItemStack> inputValidator) {
        return new InputWrapper(original, inputValidator);
    }

    public static IItemHandlerModifiable inputOnly(IItemHandlerModifiable original, BiPredicate<Integer, ItemStack> inputValidator) {
        return new InputWrapper(original, (BiPredicate)inputValidator){

            @Override
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.field_190927_a;
            }
        };
    }

    public static IItemHandlerModifiable outputOnly(IItemHandlerModifiable original) {
        return new ItemHandlerModifiableForwarder(original){

            @Override
            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                return stack;
            }

            @Override
            public boolean isItemValid(int slot, ItemStack stack) {
                return false;
            }
        };
    }

    private ItemHandlerPolicyWrapper() {
    }

    private static class InputWrapper
    extends ItemHandlerModifiableForwarder {
        private final BiPredicate<Integer, ItemStack> _inputValidator;

        public InputWrapper(IItemHandlerModifiable handler, BiPredicate<Integer, ItemStack> inputValidator) {
            super(handler);
            this._inputValidator = inputValidator;
        }

        @Override
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.isItemValid(slot, stack) ? super.insertItem(slot, stack, simulate) : stack;
        }

        @Override
        public boolean isItemValid(int slot, ItemStack stack) {
            return this._inputValidator.test(slot, stack);
        }
    }
}

