/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.multiblock.rectangular;

import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.block.BlockFacings;
import it.zerono.mods.zerocore.lib.multiblock.AbstractMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.AbstractMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.rectangular.AbstractRectangularMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.rectangular.PartPosition;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class AbstractRectangularMultiblockPart<Controller extends AbstractRectangularMultiblockController<Controller>>
extends AbstractMultiblockPart<Controller> {
    private PartPosition _position = PartPosition.Unknown;
    private BlockFacings _outwardFacings = BlockFacings.NONE;

    public AbstractRectangularMultiblockPart(TileEntityType<?> type) {
        super(type);
    }

    public abstract boolean isGoodForPosition(PartPosition var1, IMultiblockValidator var2);

    public BlockFacings getOutwardFacings() {
        return this._outwardFacings;
    }

    public PartPosition getPartPosition() {
        return this._position;
    }

    public void notifyOutwardNeighborsOfStateChange() {
        Block blockType = this.getBlockType();
        BlockFacings facings = this.getOutwardFacings();
        BlockPos position = this.getWorldPosition();
        World world = this.func_145831_w();
        if (null != world) {
            for (Direction facing : CodeHelper.DIRECTIONS) {
                if (!facings.isSet(facing)) continue;
                WorldHelper.notifyNeighborsOfStateChange(world, position.func_177972_a(facing), blockType);
            }
        }
    }

    @Override
    public void onAttached(Controller newController) {
        super.onAttached(newController);
        this.recalculateOutwardsDirection(newController);
    }

    @Override
    public void onPreMachineAssembled(Controller controller) {
        this.recalculateOutwardsDirection(controller);
    }

    @Override
    public void onPostMachineAssembled(Controller controller) {
    }

    @Override
    public void onPreMachineBroken() {
    }

    @Override
    public void onPostMachineBroken() {
        this._position = PartPosition.Unknown;
        this._outwardFacings = BlockFacings.NONE;
    }

    private void recalculateOutwardsDirection(Controller controller) {
        ((AbstractMultiblockController)controller).forBoundingBoxCoordinates((min, max) -> this.recalculateOutwardsDirection(controller, (BlockPos)min, (BlockPos)max));
    }

    private void recalculateOutwardsDirection(Controller controller, BlockPos min, BlockPos max) {
        BlockPos myPosition = this.getWorldPosition();
        boolean downFacing = myPosition.func_177956_o() == min.func_177956_o();
        boolean upFacing = myPosition.func_177956_o() == max.func_177956_o();
        boolean northFacing = myPosition.func_177952_p() == min.func_177952_p();
        boolean southFacing = myPosition.func_177952_p() == max.func_177952_p();
        boolean westFacing = myPosition.func_177958_n() == min.func_177958_n();
        boolean eastFacing = myPosition.func_177958_n() == max.func_177958_n();
        this._outwardFacings = BlockFacings.from(downFacing, upFacing, northFacing, southFacing, westFacing, eastFacing);
        this._position = PartPosition.positionIn(controller, myPosition);
    }
}

