/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.recipe.result;

import com.google.gson.JsonElement;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class ItemStackRecipeResult
implements IRecipeResult<ItemStack> {
    private final ItemStack _result;

    public static ItemStackRecipeResult from(ItemStack stack) {
        return new ItemStackRecipeResult(stack);
    }

    public static ItemStackRecipeResult from(PacketBuffer buffer) {
        return new ItemStackRecipeResult(buffer.func_150791_c());
    }

    public static ItemStackRecipeResult from(JsonElement jsonElement) {
        return new ItemStackRecipeResult(ItemHelper.stackFrom(jsonElement));
    }

    public static ItemStackRecipeResult from(IItemProvider item) {
        return ItemStackRecipeResult.from(item, 1);
    }

    public static ItemStackRecipeResult from(IItemProvider item, int amount) {
        return ItemStackRecipeResult.from(new ItemStack(item, amount));
    }

    @Override
    public ResourceLocation getId() {
        return Objects.requireNonNull(this._result.func_77973_b().getRegistryName());
    }

    @Override
    public ItemStack getResult() {
        return this._result.func_77946_l();
    }

    @Override
    public long getAmount() {
        return this._result.func_190926_b() ? 0L : (long)this._result.func_190916_E();
    }

    @Override
    public boolean isEmpty() {
        return this._result.func_190926_b();
    }

    @Override
    public void serializeTo(PacketBuffer buffer) {
        buffer.func_150788_a(this._result);
    }

    @Override
    public JsonElement serializeTo() {
        return ItemHelper.stackToJSON(this._result);
    }

    public String toString() {
        return this._result.toString();
    }

    private ItemStackRecipeResult(ItemStack stack) {
        this._result = stack;
    }
}

