/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.item.forge;

import dev.ftb.mods.ftblibrary.item.FTBLibraryItems;
import dev.ftb.mods.ftblibrary.item.FluidContainerBaseItem;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidContainerItem
extends FluidContainerBaseItem {
    public static FluidStack getFluidStack(ItemStack item) {
        return FluidUtil.getFluidContained((ItemStack)item).orElse(FluidStack.EMPTY);
    }

    public static String getFluidStackHash(ItemStack item) {
        FluidStack fs = FluidContainerItem.getFluidStack(item);
        if (fs.isEmpty()) {
            return "";
        }
        return String.format("%08X:%08X", Objects.hashCode(fs.getFluid()), Objects.hashCode(fs.getTag()));
    }

    public static ItemStack of(FluidStack fluidStack) {
        ItemStack stack = new ItemStack((IItemProvider)FTBLibraryItems.FLUID_CONTAINER.get());
        IFluidHandlerItem handler = (IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)stack).orElse(null);
        if (handler != null) {
            handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
        }
        return stack;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FluidHandlerItemStack.Consumable(stack, 1000);
    }

    public ItemStack func_190903_i() {
        return FluidContainerItem.of(new FluidStack((Fluid)Fluids.field_204546_a, 1000));
    }

    public void func_150895_a(ItemGroup tag, NonNullList<ItemStack> list) {
        if (CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY != null && this.func_194125_a(tag)) {
            for (Fluid fluid : ForgeRegistries.FLUIDS) {
                if (fluid == Fluids.field_204541_a || !fluid.func_207193_c(fluid.func_207188_f())) continue;
                list.add((Object)FluidContainerItem.of(new FluidStack(fluid, 1000)));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World level, List<ITextComponent> tooltip, ITooltipFlag flag) {
        FluidStack fluidStack = FluidContainerItem.getFluidStack(stack);
        if (!fluidStack.isEmpty()) {
            tooltip.add((ITextComponent)new StringTextComponent("< ").func_230529_a_((ITextComponent)new TranslationTextComponent("ftblibrary.mb", new Object[]{fluidStack.getAmount(), fluidStack.getDisplayName()})).func_240702_b_(" >").func_240699_a_(TextFormatting.GRAY));
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("item.ftblibrary.fluid_container.use").func_240699_a_(TextFormatting.DARK_GRAY));
    }
}

