/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.snbt;

import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.EndNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.Nullable;

public class SNBTNet {
    public static final ByteArrayNBT EMPTY_BYTE_ARRAY = new ByteArrayNBT(new byte[0]);
    public static final IntArrayNBT EMPTY_INT_ARRAY = new IntArrayNBT(new int[0]);
    public static final LongArrayNBT EMPTY_LONG_ARRAY = new LongArrayNBT(new long[0]);

    public static void write(PacketBuffer buf, @Nullable INBT tag) {
        if (tag instanceof ByteNBT) {
            buf.writeByte((int)((ByteNBT)tag).func_150290_f());
        } else if (tag instanceof ShortNBT) {
            buf.writeShort((int)((ShortNBT)tag).func_150289_e());
        } else if (tag instanceof IntNBT) {
            buf.writeInt(((IntNBT)tag).func_150287_d());
        } else if (tag instanceof LongNBT) {
            buf.writeLong(((LongNBT)tag).func_150291_c());
        } else if (tag instanceof FloatNBT) {
            buf.writeFloat(((FloatNBT)tag).func_150288_h());
        } else if (tag instanceof DoubleNBT) {
            buf.writeDouble(((DoubleNBT)tag).func_150286_g());
        } else if (tag instanceof ByteArrayNBT) {
            SNBTNet.writeByteArray(buf, (ByteArrayNBT)tag);
        } else if (tag instanceof StringNBT) {
            buf.func_211400_a(tag.func_150285_a_(), Short.MAX_VALUE);
        } else if (tag instanceof ListNBT) {
            SNBTNet.writeList(buf, (ListNBT)tag);
        } else if (tag instanceof CompoundNBT) {
            SNBTNet.writeCompound(buf, SNBTCompoundTag.of(tag));
        } else if (tag instanceof IntArrayNBT) {
            SNBTNet.writeIntArray(buf, (IntArrayNBT)tag);
        } else if (tag instanceof LongArrayNBT) {
            SNBTNet.writeLongArray(buf, (LongArrayNBT)tag);
        }
    }

    public static void writeCompound(PacketBuffer buf, @Nullable SNBTCompoundTag tag) {
        if (tag == null) {
            buf.func_150787_b(-1);
            return;
        }
        buf.func_150787_b(tag.func_150296_c().size());
        for (String s : tag.func_150296_c()) {
            buf.func_211400_a(s, Short.MAX_VALUE);
            buf.writeByte((int)tag.func_74781_a(s).func_74732_a());
            SNBTNet.write(buf, tag.func_74781_a(s));
        }
    }

    public static void writeList(PacketBuffer buf, @Nullable ListNBT tag) {
        if (tag == null) {
            buf.func_150787_b(-1);
            return;
        }
        buf.func_150787_b(tag.size());
        if (!tag.isEmpty()) {
            buf.writeByte((int)tag.func_230528_d__());
            for (INBT value : tag) {
                SNBTNet.write(buf, value);
            }
        }
    }

    public static void writeByteArray(PacketBuffer buf, @Nullable ByteArrayNBT tag) {
        if (tag == null) {
            buf.func_150787_b(-1);
            return;
        }
        buf.func_150787_b(tag.size());
        for (byte v : tag.func_150292_c()) {
            buf.writeByte((int)v);
        }
    }

    public static void writeIntArray(PacketBuffer buf, @Nullable IntArrayNBT tag) {
        if (tag == null) {
            buf.func_150787_b(-1);
            return;
        }
        buf.func_150787_b(tag.size());
        for (int v : tag.func_150302_c()) {
            buf.writeInt(v);
        }
    }

    public static void writeLongArray(PacketBuffer buf, @Nullable LongArrayNBT tag) {
        if (tag == null) {
            buf.func_150787_b(-1);
            return;
        }
        buf.func_150787_b(tag.size());
        for (long v : tag.func_197652_h()) {
            buf.writeLong(v);
        }
    }

    @Nullable
    public static INBT read(byte type, PacketBuffer buf) {
        switch (type) {
            case 0: {
                return EndNBT.field_229686_b_;
            }
            case 1: {
                return ByteNBT.func_229671_a_((byte)buf.readByte());
            }
            case 2: {
                return ShortNBT.func_229701_a_((short)buf.readShort());
            }
            case 3: {
                return IntNBT.func_229692_a_((int)buf.readInt());
            }
            case 4: {
                return LongNBT.func_229698_a_((long)buf.readLong());
            }
            case 5: {
                return FloatNBT.func_229689_a_((float)buf.readFloat());
            }
            case 6: {
                return DoubleNBT.func_229684_a_((double)buf.readDouble());
            }
            case 7: {
                return SNBTNet.readByteArray(buf);
            }
            case 8: {
                return StringNBT.func_229705_a_((String)buf.func_150789_c(Short.MAX_VALUE));
            }
            case 9: {
                return SNBTNet.readList(buf);
            }
            case 10: {
                return SNBTNet.readCompound(buf);
            }
            case 11: {
                return SNBTNet.readIntArray(buf);
            }
            case 12: {
                return SNBTNet.readLongArray(buf);
            }
        }
        return null;
    }

    @Nullable
    public static SNBTCompoundTag readCompound(PacketBuffer buf) {
        int len = buf.func_150792_a();
        if (len == -1) {
            return null;
        }
        SNBTCompoundTag tag = new SNBTCompoundTag();
        for (int i = 0; i < len; ++i) {
            String key = buf.func_150789_c(Short.MAX_VALUE);
            byte type = buf.readByte();
            tag.func_218657_a(key, SNBTNet.read(type, buf));
        }
        return tag;
    }

    @Nullable
    public static ListNBT readList(PacketBuffer buf) {
        int len = buf.func_150792_a();
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return new ListNBT();
        }
        byte type = buf.readByte();
        ListNBT tag = new ListNBT();
        for (int i = 0; i < len; ++i) {
            tag.add((Object)SNBTNet.read(type, buf));
        }
        return tag;
    }

    public static ByteArrayNBT readByteArray(PacketBuffer buf) {
        int len = buf.func_150792_a();
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] values = new byte[len];
        for (int i = 0; i < len; ++i) {
            values[i] = buf.readByte();
        }
        return new ByteArrayNBT(values);
    }

    public static IntArrayNBT readIntArray(PacketBuffer buf) {
        int len = buf.func_150792_a();
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] values = new int[len];
        for (int i = 0; i < len; ++i) {
            values[i] = buf.readInt();
        }
        return new IntArrayNBT(values);
    }

    public static LongArrayNBT readLongArray(PacketBuffer buf) {
        int len = buf.func_150792_a();
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] values = new long[len];
        for (int i = 0; i < len; ++i) {
            values[i] = buf.readLong();
        }
        return new LongArrayNBT(values);
    }
}

