/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.corelib.death;

import de.maxhenkel.gravestone.corelib.item.ItemUtils;
import de.maxhenkel.gravestone.corelib.player.PlayerUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;

public class Death {
    private UUID id;
    private UUID playerUUID;
    private String playerName;
    private NonNullList<ItemStack> mainInventory = NonNullList.func_191197_a((int)36, (Object)ItemStack.field_190927_a);
    private NonNullList<ItemStack> armorInventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private NonNullList<ItemStack> offHandInventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    private NonNullList<ItemStack> additionalItems = NonNullList.func_191196_a();
    private NonNullList<ItemStack> equipment = NonNullList.func_191197_a((int)EquipmentSlotType.values().length, (Object)ItemStack.field_190927_a);
    private long timestamp;
    private int experience;
    private double posX;
    private double posY;
    private double posZ;
    private String dimension;
    private byte model;

    private Death() {
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public NonNullList<ItemStack> getMainInventory() {
        return this.mainInventory;
    }

    public NonNullList<ItemStack> getArmorInventory() {
        return this.armorInventory;
    }

    public NonNullList<ItemStack> getOffHandInventory() {
        return this.offHandInventory;
    }

    public NonNullList<ItemStack> getAdditionalItems() {
        return this.additionalItems;
    }

    public NonNullList<ItemStack> getEquipment() {
        return this.equipment;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getExperience() {
        return this.experience;
    }

    public double getPosX() {
        return this.posX;
    }

    public double getPosY() {
        return this.posY;
    }

    public double getPosZ() {
        return this.posZ;
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.posX, this.posY, this.posZ);
    }

    public String getDimension() {
        return this.dimension;
    }

    public byte getModel() {
        return this.model;
    }

    public String toString() {
        return "Death{name=" + this.playerName + "timestamp=" + this.timestamp + "}";
    }

    public static Death fromPlayer(PlayerEntity player) {
        int i;
        Death death = new Death();
        death.id = UUID.randomUUID();
        death.playerUUID = player.func_110124_au();
        death.playerName = player.func_200200_C_().func_150261_e();
        for (i = 0; i < death.mainInventory.size(); ++i) {
            death.mainInventory.set(i, player.field_71071_by.field_70462_a.get(i));
        }
        for (i = 0; i < death.armorInventory.size(); ++i) {
            death.armorInventory.set(i, player.field_71071_by.field_70460_b.get(i));
        }
        for (i = 0; i < death.offHandInventory.size(); ++i) {
            death.offHandInventory.set(i, player.field_71071_by.field_184439_c.get(i));
        }
        death.equipment = NonNullList.func_191197_a((int)EquipmentSlotType.values().length, (Object)ItemStack.field_190927_a);
        for (i = 0; i < death.equipment.size(); ++i) {
            death.equipment.set(i, (Object)player.func_184582_a(EquipmentSlotType.values()[i]).func_77946_l());
        }
        death.timestamp = System.currentTimeMillis();
        death.experience = player.field_71068_ca;
        death.posX = player.func_226277_ct_();
        death.posY = player.func_226278_cu_();
        death.posZ = player.func_226281_cx_();
        death.dimension = player.field_70170_p.func_234923_W_().func_240901_a_().toString();
        death.model = PlayerUtils.getModel(player);
        return death;
    }

    public void processDrops(Collection<ItemEntity> items) {
        List<ItemStack> drops = items.stream().filter(Objects::nonNull).map(ItemEntity::func_92059_d).filter(itemStack -> !itemStack.func_190926_b()).collect(Collectors.toList());
        this.processInventory(drops, this.mainInventory);
        this.processInventory(drops, this.armorInventory);
        this.processInventory(drops, this.offHandInventory);
        this.additionalItems.addAll(drops);
    }

    private void processInventory(List<ItemStack> drops, NonNullList<ItemStack> inventory) {
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack itemStack = (ItemStack)inventory.get(i);
            if (itemStack.func_190926_b()) continue;
            if (drops.contains(itemStack)) {
                drops.remove(itemStack);
                continue;
            }
            inventory.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public NonNullList<ItemStack> getAllItems() {
        NonNullList items = NonNullList.func_191196_a();
        items.addAll(this.filterList((List<ItemStack>)this.mainInventory));
        items.addAll(this.filterList((List<ItemStack>)this.armorInventory));
        items.addAll(this.filterList((List<ItemStack>)this.offHandInventory));
        items.addAll(this.filterList((List<ItemStack>)this.additionalItems));
        return items;
    }

    private List<ItemStack> filterList(List<ItemStack> stacks) {
        return stacks.stream().filter(itemStack -> !itemStack.func_190926_b()).collect(Collectors.toList());
    }

    public static Death fromNBT(CompoundNBT compound) {
        Death death = new Death();
        death.id = new UUID(compound.func_74763_f("IdMost"), compound.func_74763_f("IdLeast"));
        death.playerUUID = new UUID(compound.func_74763_f("PlayerUuidMost"), compound.func_74763_f("PlayerUuidLeast"));
        death.playerName = compound.func_74779_i("PlayerName");
        ItemUtils.readInventory(compound, "MainInventory", death.mainInventory);
        ItemUtils.readInventory(compound, "ArmorInventory", death.armorInventory);
        ItemUtils.readInventory(compound, "OffHandInventory", death.offHandInventory);
        death.additionalItems = ItemUtils.readItemList(compound, "Items");
        ItemUtils.readItemList(compound, "Equipment", death.equipment);
        death.timestamp = compound.func_74763_f("Timestamp");
        death.experience = compound.func_74762_e("Experience");
        death.posX = compound.func_74769_h("PosX");
        death.posY = compound.func_74769_h("PosY");
        death.posZ = compound.func_74769_h("PosZ");
        death.dimension = compound.func_74779_i("Dimension");
        death.model = compound.func_74771_c("Model");
        return death;
    }

    public CompoundNBT toNBT() {
        return this.toNBT(true);
    }

    public CompoundNBT toNBT(boolean withItems) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74772_a("IdMost", this.id.getMostSignificantBits());
        compound.func_74772_a("IdLeast", this.id.getLeastSignificantBits());
        compound.func_74772_a("PlayerUuidMost", this.playerUUID.getMostSignificantBits());
        compound.func_74772_a("PlayerUuidLeast", this.playerUUID.getLeastSignificantBits());
        compound.func_74778_a("PlayerName", this.playerName);
        if (withItems) {
            ItemUtils.saveInventory(compound, "MainInventory", this.mainInventory);
            ItemUtils.saveInventory(compound, "ArmorInventory", this.armorInventory);
            ItemUtils.saveInventory(compound, "OffHandInventory", this.offHandInventory);
            ItemUtils.saveItemList(compound, "Items", this.additionalItems);
        }
        ItemUtils.saveItemList(compound, "Equipment", this.equipment);
        compound.func_74772_a("Timestamp", this.timestamp);
        compound.func_74768_a("Experience", this.experience);
        compound.func_74780_a("PosX", this.posX);
        compound.func_74780_a("PosY", this.posY);
        compound.func_74780_a("PosZ", this.posZ);
        compound.func_74778_a("Dimension", this.dimension);
        compound.func_74774_a("Model", this.model);
        return compound;
    }

    public static class Builder {
        private Death death = new Death();

        public Builder(UUID playerUUID, UUID id) {
            this.death.dimension = "";
            this.death.playerName = "";
            this.death.playerUUID = playerUUID;
            this.death.id = id;
        }

        public Death build() {
            return this.death;
        }

        public Builder id(UUID uuid) {
            this.death.id = uuid;
            return this;
        }

        public Builder playerUUID(UUID uuid) {
            this.death.playerUUID = uuid;
            return this;
        }

        public Builder playerName(String name) {
            this.death.playerName = name;
            return this;
        }

        public Builder mainInventory(NonNullList<ItemStack> list) {
            this.death.mainInventory = list;
            return this;
        }

        public Builder armorInventory(NonNullList<ItemStack> list) {
            this.death.armorInventory = list;
            return this;
        }

        public Builder offHandInventory(NonNullList<ItemStack> list) {
            this.death.offHandInventory = list;
            return this;
        }

        public Builder additionalItems(NonNullList<ItemStack> list) {
            this.death.additionalItems = list;
            return this;
        }

        public Builder equipment(NonNullList<ItemStack> list) {
            this.death.equipment = list;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.death.timestamp = timestamp;
            return this;
        }

        public Builder experience(int experience) {
            this.death.experience = experience;
            return this;
        }

        public Builder posX(double posX) {
            this.death.posX = posX;
            return this;
        }

        public Builder posY(double posY) {
            this.death.posY = posY;
            return this;
        }

        public Builder posZ(double posZ) {
            this.death.posZ = posZ;
            return this;
        }

        public Builder dimension(String dimension) {
            this.death.dimension = dimension;
            return this;
        }

        public Builder model(byte model) {
            this.death.model = model;
            return this;
        }
    }
}

