/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalcustomization.create;

import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.blakebr0.mysticalcustomization.loader.CropTierLoader;
import com.blakebr0.mysticalcustomization.util.ParsingUtils;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public final class CropTierCreator {
    public static CropTier create(ResourceLocation id, JsonObject json) throws JsonSyntaxException {
        int value = JSONUtils.func_151203_m((JsonObject)json, (String)"value");
        String colorString = JSONUtils.func_151219_a((JsonObject)json, (String)"color", (String)"ffffff");
        int color = ParsingUtils.parseHex(colorString, "color");
        CropTier tier = new CropTier(id, value, color, TextFormatting.WHITE);
        if (json.has("name")) {
            String name = JSONUtils.func_151200_h((JsonObject)json, (String)"name");
            tier.setDisplayName((IFormattableTextComponent)new StringTextComponent(name));
        }
        if (json.has("fertilizable")) {
            boolean fertilizable = JSONUtils.func_151212_i((JsonObject)json, (String)"fertilizable");
            tier.setFertilizable(fertilizable);
        }
        if (json.has("secondarySeedDrop")) {
            boolean secondarySeedDrop = JSONUtils.func_151212_i((JsonObject)json, (String)"secondarySeedDrop");
            tier.setSecondarySeedDrop(secondarySeedDrop);
        }
        if (json.has("farmland")) {
            String blockId = JSONUtils.func_151200_h((JsonObject)json, (String)"farmland");
            CropTierLoader.FARMLAND_MAP.put(tier, new ResourceLocation(blockId));
        }
        if (json.has("essence")) {
            String itemId = JSONUtils.func_151200_h((JsonObject)json, (String)"essence");
            CropTierLoader.ESSENCE_MAP.put(tier, new ResourceLocation(itemId));
        }
        return tier;
    }
}

