/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalcustomization.loader;

import com.blakebr0.mysticalagriculture.api.registry.IAugmentRegistry;
import com.blakebr0.mysticalagriculture.api.tinkering.IAugment;
import com.blakebr0.mysticalcustomization.modify.AugmentModifier;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class AugmentLoader {
    private static final Logger LOGGER = LogManager.getLogger((String)"Mystical Customization");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPostRegisterAugments(IAugmentRegistry registry) {
        block19: {
            File file;
            block20: {
                File dir = FMLPaths.CONFIGDIR.get().resolve("mysticalcustomization/").toFile();
                if (!dir.exists() && dir.mkdirs()) {
                    LOGGER.info("Created /config/mysticalcustomization/ directory");
                }
                if (!(file = FMLPaths.CONFIGDIR.get().resolve("mysticalcustomization/configure-augments.json").toFile()).exists() || !file.isFile()) break block20;
                FileReader reader = null;
                try {
                    JsonParser parser = new JsonParser();
                    reader = new FileReader(file);
                    JsonObject json = parser.parse((Reader)reader).getAsJsonObject();
                    json.entrySet().forEach(entry -> {
                        String id = (String)entry.getKey();
                        JsonObject changes = ((JsonElement)entry.getValue()).getAsJsonObject();
                        IAugment augment = registry.getAugmentById(new ResourceLocation(id));
                        if (augment == null) {
                            String error = String.format("Invalid augment id provided: %s", id);
                            throw new JsonParseException(error);
                        }
                        AugmentModifier.modify(augment, changes);
                    });
                    reader.close();
                }
                catch (Exception e) {
                    try {
                        LOGGER.error("An error occurred while reading configure-augment.json", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(reader);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Reader)reader);
                    break block19;
                }
                IOUtils.closeQuietly((Reader)reader);
                break block19;
            }
            try (FileWriter writer = new FileWriter(file);){
                JsonObject object = new JsonObject();
                GSON.toJson((JsonElement)object, (Appendable)writer);
            }
            catch (IOException e) {
                LOGGER.error("An error occurred while creating configure-augment.json", (Throwable)e);
            }
        }
    }
}

