/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalcustomization.loader;

import com.blakebr0.mysticalagriculture.api.crop.ICrop;
import com.blakebr0.mysticalagriculture.api.registry.ICropRegistry;
import com.blakebr0.mysticalcustomization.create.CropCreator;
import com.blakebr0.mysticalcustomization.modify.CropModifier;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CropLoader {
    private static final Logger LOGGER = LogManager.getLogger((String)"Mystical Customization");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final Map<ICrop, ResourceLocation> CRUX_MAP = new HashMap<ICrop, ResourceLocation>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onRegisterCrops(ICropRegistry registry) {
        File[] files;
        File dir = FMLPaths.CONFIGDIR.get().resolve("mysticalcustomization/crops/").toFile();
        if (!dir.exists() && dir.mkdirs()) {
            LOGGER.info("Created /config/mysticalcustomization/crops/ directory");
        }
        if ((files = dir.listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".json"))) == null) {
            return;
        }
        for (File file : files) {
            FileReader reader = null;
            ResourceLocation id = null;
            ICrop crop = null;
            try {
                JsonParser parser = new JsonParser();
                reader = new FileReader(file);
                JsonObject json = parser.parse((Reader)reader).getAsJsonObject();
                String name = file.getName().replace(".json", "");
                id = new ResourceLocation("mysticalcustomization", name);
                crop = CropCreator.create(id, json);
                reader.close();
            }
            catch (Exception e) {
                try {
                    LOGGER.error("An error occurred while creating crop with id {}", id, (Object)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)reader);
            }
            IOUtils.closeQuietly((Reader)reader);
            if (crop == null) continue;
            registry.register(crop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPostRegisterCrops(ICropRegistry registry) {
        block19: {
            File file;
            block20: {
                File dir = FMLPaths.CONFIGDIR.get().resolve("mysticalcustomization/").toFile();
                if (!dir.exists() && dir.mkdirs()) {
                    LOGGER.info("Created /config/mysticalcustomization/ directory");
                }
                if (!(file = FMLPaths.CONFIGDIR.get().resolve("mysticalcustomization/configure-crops.json").toFile()).exists() || !file.isFile()) break block20;
                FileReader reader = null;
                try {
                    JsonParser parser = new JsonParser();
                    reader = new FileReader(file);
                    JsonObject json = parser.parse((Reader)reader).getAsJsonObject();
                    json.entrySet().forEach(entry -> {
                        String id = (String)entry.getKey();
                        JsonObject changes = ((JsonElement)entry.getValue()).getAsJsonObject();
                        ICrop crop = registry.getCropById(new ResourceLocation(id));
                        if (crop == null) {
                            String error = String.format("Invalid crop id provided: %s", id);
                            throw new JsonParseException(error);
                        }
                        CropModifier.modify(crop, changes);
                    });
                    reader.close();
                }
                catch (Exception e) {
                    try {
                        LOGGER.error("An error occurred while reading configure-crops.json", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(reader);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Reader)reader);
                    break block19;
                }
                IOUtils.closeQuietly((Reader)reader);
                break block19;
            }
            try (FileWriter writer = new FileWriter(file);){
                JsonObject object = new JsonObject();
                GSON.toJson((JsonElement)object, (Appendable)writer);
            }
            catch (IOException e) {
                LOGGER.error("An error occurred while creating configure-crops.json", (Throwable)e);
            }
        }
    }

    public static void onCommonSetup() {
        CRUX_MAP.forEach((crop, crux) -> {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(crux);
            if (block != Blocks.field_150350_a) {
                crop.setCrux(() -> block);
            } else {
                LOGGER.error("Could not find crux for crop {}", (Object)crop.getId());
            }
        });
    }
}

