/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.datagen;

import it.zerono.mods.zerocore.lib.datagen.provider.multiblock.AbstractCuboidMultiblockBlockStateProvider;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.Property;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public abstract class AbstractMultiblockBlockStateGenerator
extends AbstractCuboidMultiblockBlockStateProvider {
    public AbstractMultiblockBlockStateGenerator(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "bigreactors", exFileHelper);
    }

    protected void genAssembledPlatingModel(String subFolder) {
        String fullPath = AbstractMultiblockBlockStateGenerator.fullResourceName((String)"", (String)subFolder);
        this.models().cubeAll(fullPath + "assembledplating", this.modLoc(fullPath + "plating"));
    }

    protected void genController(Supplier<? extends Block> block, String subFolder) {
        this.genericPart(block, "controller", subFolder, true, "_on", "_off");
    }

    protected void genFluidPort(Supplier<? extends Block> block, String resourceName, String subFolder) {
        BlockModelProvider mbp = this.models();
        String fullResourceName = AbstractMultiblockBlockStateGenerator.fullResourceName((String)resourceName, (String)subFolder);
        this.simpleBlock(block.get(), (ModelFile)mbp.cubeAll(fullResourceName + "_cold", this.modLoc(fullResourceName + "_cold")), true);
        this.genericPartSubModels(fullResourceName, "_cold_connected", "_hot", "_hot_connected");
    }

    protected void genRedstonePort(Supplier<? extends Block> block, String subFolder) {
        this.genericPart(block, "redstoneport", subFolder, true, "_on");
    }

    protected void genComputerPort(Supplier<? extends Block> block, String subFolder) {
        this.genericPart(block, "computerport", subFolder, true, "_connected");
    }

    protected void genericPart(Supplier<? extends Block> block, String resourceName, String subFolder, String ... variantSuffixes) {
        this.genericPart(block, resourceName, subFolder, false, variantSuffixes);
    }

    protected void genericPart(Supplier<? extends Block> block, String resourceName, String subFolder, boolean genStandardItem, String ... variantSuffixes) {
        BlockModelProvider mbp = this.models();
        String fullResourceName = AbstractMultiblockBlockStateGenerator.fullResourceName((String)resourceName, (String)subFolder);
        this.simpleBlock(block.get(), (ModelFile)mbp.cubeAll(fullResourceName, this.modLoc(fullResourceName)), genStandardItem);
        this.genericPartSubModels(fullResourceName, variantSuffixes);
    }

    protected void genericPartSubModels(String fullResourceName, String ... variantSuffixes) {
        BlockModelProvider mbp = this.models();
        for (String suffix : variantSuffixes) {
            mbp.cubeAll(fullResourceName + suffix, this.modLoc(fullResourceName + suffix));
        }
    }

    protected <T extends Comparable<T>> void genPropertyVariant(Block block, Property<T> property, T propertyValue, ModelFile model) {
        this.genPropertyVariant(block, property, propertyValue, model, 0, 0, false);
    }

    protected <T extends Comparable<T>> void genPropertyVariant(Block block, Property<T> property, T propertyValue, ModelFile model, int rotationX, int rotationY) {
        this.genPropertyVariant(block, property, propertyValue, model, rotationX, rotationY, false);
    }

    protected <T extends Comparable<T>> void genPropertyVariant(Block block, Property<T> property, T propertyValue, ModelFile model, int rotationX, int rotationY, boolean uvLock) {
        this.getVariantBuilder(block).partialState().with(property, propertyValue).modelForState().modelFile(model).rotationX(rotationX).rotationY(rotationY).uvLock(uvLock).addModel();
    }
}

