/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent;

import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.config.Config;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.zerocore.lib.world.WorldGenManager;
import it.zerono.mods.zerocore.lib.world.WorldReGenHandler;
import java.util.function.Predicate;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

public final class WorldGen {
    private static WorldReGenHandler s_regen;

    public static void initialize() {
        s_regen = new WorldReGenHandler("ergen", () -> ((ForgeConfigSpec.IntValue)Config.COMMON.worldgen.userWorldGenVersion).get(), () -> (Boolean)Config.COMMON.worldgen.enableWorldGen.get() != false && (Boolean)Config.COMMON.worldgen.enableWorldRegeneration.get() != false);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Feature.class, EventPriority.LOW, WorldGen::register);
    }

    public static void register(RegistryEvent.Register<Feature<?>> event) {
        Pair yelloriteGenerators = WorldReGenHandler.oreGenAndRegenFeatures(Content.Blocks.YELLORITE_ORE_BLOCK, (RuleTest)WorldGenManager.oreMatch((ITag)Tags.Blocks.STONE), (int)((Integer)Config.COMMON.worldgen.yelloriteOreMaxClustersPerChunk.get()), (int)((Integer)Config.COMMON.worldgen.yelloriteOrePerCluster.get()), (int)15, (int)5, (int)((Integer)Config.COMMON.worldgen.yelloriteOreMaxY.get()));
        Pair anglesiteGenerators = WorldReGenHandler.oreGenAndRegenFeatures(Content.Blocks.ANGLESITE_ORE_BLOCK, (RuleTest)WorldGenManager.oreMatch((ITag)Tags.Blocks.END_STONES), (int)((Integer)Config.COMMON.worldgen.anglesiteOreMaxClustersPerChunk.get()), (int)((Integer)Config.COMMON.worldgen.anglesiteOrePerCluster.get()), (int)5, (int)5, (int)200);
        Pair benitoiteGenerators = WorldReGenHandler.oreGenAndRegenFeatures(Content.Blocks.BENITOITE_ORE_BLOCK, (RuleTest)WorldGenManager.oreMatch((ITag)Tags.Blocks.NETHERRACK), (int)((Integer)Config.COMMON.worldgen.benitoiteOreMaxClustersPerChunk.get()), (int)((Integer)Config.COMMON.worldgen.benitoiteOrePerCluster.get()), (int)5, (int)5, (int)256);
        WorldGen.registerToVanilla(yelloriteGenerators, "yellorite");
        WorldGen.registerToVanilla(anglesiteGenerators, "anglesite");
        WorldGen.registerToVanilla(benitoiteGenerators, "benitoite");
        Predicate<BiomeLoadingEvent> yelloriteGenEnabled = e -> (Boolean)Config.COMMON.worldgen.enableWorldGen.get() != false && (Boolean)Config.COMMON.worldgen.yelloriteOreEnableWorldGen.get() != false;
        Predicate<BiomeLoadingEvent> anglesiteGenEnabled = e -> (Boolean)Config.COMMON.worldgen.enableWorldGen.get() != false && (Boolean)Config.COMMON.worldgen.anglesiteOreEnableWorldGen.get() != false;
        Predicate<BiomeLoadingEvent> benitoiteGenEnabled = e -> (Boolean)Config.COMMON.worldgen.enableWorldGen.get() != false && (Boolean)Config.COMMON.worldgen.benitoiteOreEnableWorldGen.get() != false;
        Predicate<Biome> yelloriteReGenEnabled = e -> (Boolean)Config.COMMON.worldgen.yelloriteOreEnableWorldGen.get();
        Predicate<Biome> anglesiteReGenEnabled = e -> (Boolean)Config.COMMON.worldgen.anglesiteOreEnableWorldGen.get();
        Predicate<Biome> benitoiteReGenEnabled = e -> (Boolean)Config.COMMON.worldgen.benitoiteOreEnableWorldGen.get();
        s_regen.addGenAndRegenOre(yelloriteGenerators, yelloriteGenEnabled, yelloriteReGenEnabled);
        s_regen.addGenAndRegenOre(anglesiteGenerators, anglesiteGenEnabled, anglesiteReGenEnabled);
        s_regen.addGenAndRegenOre(benitoiteGenerators, benitoiteGenEnabled, benitoiteReGenEnabled);
    }

    private static void registerToVanilla(Pair<ConfiguredFeature<?, ?>, ConfiguredFeature<?, ?>> generators, String name) {
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)ExtremeReactors.newID(name + "_gen"), (Object)generators.getLeft());
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)ExtremeReactors.newID(name + "_regen"), (Object)generators.getRight());
    }
}

