/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import it.zerono.mods.extremereactors.api.IMapping;
import it.zerono.mods.extremereactors.api.reactor.Moderator;
import it.zerono.mods.extremereactors.api.reactor.ModeratorsRegistry;
import it.zerono.mods.extremereactors.api.reactor.Reactant;
import it.zerono.mods.extremereactors.api.reactor.ReactantMappingsRegistry;
import it.zerono.mods.extremereactors.api.reactor.ReactantType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.FuelContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IFuelSource;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.ReactantStack;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.IMultiblockReactorVariant;
import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;

public class ReactantHelper {
    private static final Cache<BlockState, Moderator> s_moderatorsCache = CacheBuilder.newBuilder().initialCapacity(4).concurrencyLevel(2).maximumSize(128L).expireAfterAccess(5L, TimeUnit.MINUTES).build();

    public static boolean isValidSource(ReactantType type, ItemStack stack) {
        return !stack.func_190926_b() && ReactantMappingsRegistry.getFromSolid(stack).map(IMapping::getProduct).map(reactant -> type == reactant.getType()).orElse(false) != false;
    }

    static ReactantStack reactantFromSolidSource(ItemStack sourceStack, IMultiblockReactorVariant variant) {
        return ReactantMappingsRegistry.getFromSolid(sourceStack).map(m -> new ReactantStack((Reactant)m.getProduct(), variant.solidSourceAmountToReactantAmount(m.getProductAmount(sourceStack.func_190916_E())))).orElse(ReactantStack.EMPTY);
    }

    static ReactantStack reactantFromFluidSource(FluidStack sourceStack, IMultiblockReactorVariant variant) {
        return ReactantStack.EMPTY;
    }

    static boolean ejectSolidReactant(ReactantType type, FuelContainer container, boolean voidLeftover, Stream<IFuelSource<ItemStack>> fuelSources) {
        boolean ejected = container.getContent(type).map(reactant -> ReactantHelper.ejectSolidReactant(reactant, container, fuelSources)).orElse(false);
        if (ejected && voidLeftover) {
            container.clear(type);
        }
        return ejected;
    }

    static boolean ejectSolidReactant(Reactant reactant, FuelContainer container, Stream<IFuelSource<ItemStack>> fuelSources) {
        int minimumReactantAmount = reactant.getMinimumSolidSourceAmount();
        return container.getContentAmount(reactant.getType()) >= minimumReactantAmount && ReactantHelper.ejectSolidReactant(reactant, minimumReactantAmount, container, fuelSources) > 0;
    }

    static int ejectSolidReactant(Reactant reactant, int minimumReactantAmount, FuelContainer container, Stream<IFuelSource<ItemStack>> fuelSources) {
        return fuelSources.mapToInt(port -> ReactantHelper.ejectSolidReactant(reactant, minimumReactantAmount, container, port)).sum();
    }

    static int ejectSolidReactant(Reactant reactant, int minimumReactantAmount, FuelContainer container, IFuelSource<ItemStack> fuelSource) {
        if (container.getContentAmount(reactant.getType()) >= minimumReactantAmount) {
            int reactantEjected = fuelSource.emitReactant(reactant, container.getContentAmount(reactant.getType()));
            return container.voidReactant(reactant.getType(), reactantEjected);
        }
        return 0;
    }

    static boolean refuelSolid(FuelContainer container, Stream<IFuelSource<ItemStack>> sources, IMultiblockReactorVariant variant) {
        return sources.filter(source -> container.getFreeSpace(ReactantType.Fuel) >= 1000).mapToInt(source -> ReactantHelper.refuelSolid(container, source, variant)).sum() > 0;
    }

    private static int refuelSolid(FuelContainer container, IFuelSource<ItemStack> fuelSource, IMultiblockReactorVariant variant) {
        ItemStack fuelSourceStack = fuelSource.getFuelStack();
        return ReactantMappingsRegistry.getFromSolid(fuelSourceStack).filter(mapping -> ((Reactant)mapping.getProduct()).getType().isFuel()).map(mapping -> ReactantHelper.refuelSolid(container, fuelSource, variant, fuelSourceStack, mapping)).orElse(0);
    }

    private static int refuelSolid(FuelContainer container, IFuelSource<ItemStack> fuelSource, IMultiblockReactorVariant variant, ItemStack fuelSourceStack, IMapping<ResourceLocation, Reactant> fuelMapping) {
        ItemStack fuelConsumedStack;
        ReactantStack availableFuel = new ReactantStack(fuelMapping, fuelSourceStack.func_190916_E());
        if (availableFuel.isEmpty() || !availableFuel.getReactant().isPresent()) {
            return 0;
        }
        int storableReactantAmount = container.insertFuel(availableFuel, OperationMode.Simulate);
        if (storableReactantAmount <= 0) {
            return 0;
        }
        ItemStack maxSourceToConsume = ItemHelper.stackFrom((ItemStack)fuelSourceStack, (int)fuelMapping.getSourceAmount(storableReactantAmount));
        if (!maxSourceToConsume.func_190926_b() && !(fuelConsumedStack = fuelSource.consumeFuelSource(maxSourceToConsume)).func_190926_b() && fuelConsumedStack.func_190916_E() > 0) {
            float conversionEfficiency = MathHelper.func_76131_a((float)variant.getSolidFuelConversionEfficiency(), (float)0.0f, (float)1.0f);
            int amountToAdd = fuelMapping.getProductAmount(fuelConsumedStack.func_190916_E());
            if (conversionEfficiency < 1.0f) {
                amountToAdd = MathHelper.func_76141_d((float)((float)amountToAdd * conversionEfficiency));
            }
            amountToAdd = Math.min(storableReactantAmount, amountToAdd);
            return container.insertFuel(availableFuel.getReactant().get(), amountToAdd, OperationMode.Execute);
        }
        return 0;
    }

    @Nullable
    public static Moderator getModeratorFrom(BlockState state) {
        return ReactantHelper.getCachedModeratorFrom(state);
    }

    public static Moderator getModeratorFrom(BlockState state, Moderator fallbackModerator) {
        Moderator moderator = ReactantHelper.getCachedModeratorFrom(state);
        return null != moderator ? moderator : fallbackModerator;
    }

    public static boolean isValidModerator(BlockState state) {
        return null != ReactantHelper.getCachedModeratorFrom(state);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onVanillaTagsUpdated(TagsUpdatedEvent.VanillaTagTypes event) {
        s_moderatorsCache.invalidateAll();
    }

    @Nullable
    private static Moderator getCachedModeratorFrom(BlockState state) {
        Optional<Moderator> m;
        Moderator moderator = (Moderator)s_moderatorsCache.getIfPresent((Object)state);
        if (null == moderator && (m = ModeratorsRegistry.getFrom(state)).isPresent()) {
            moderator = m.get();
            s_moderatorsCache.put((Object)state, (Object)moderator);
        }
        return moderator;
    }
}

