/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagradditions.item;

import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.cucumber.lib.Tooltips;
import com.blakebr0.mysticalagradditions.config.ModConfigs;
import com.blakebr0.mysticalagradditions.lib.ModTooltips;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class EssenceAppleItem
extends BaseItem {
    private static final Food.Builder food = new Food.Builder().func_221455_b();
    private final EssenceAppleTier tier;

    public EssenceAppleItem(EssenceAppleTier tier, Function<Item.Properties, Item.Properties> properties) {
        super(properties.compose(p -> p.func_221540_a(food.func_221456_a(tier.hunger).func_221454_a(tier.saturation).func_221453_d())));
        this.tier = tier;
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entity) {
        if (!world.func_201670_d()) {
            this.tier.onFoodEaten(entity);
        }
        return entity.func_213357_a(world, stack);
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)ModTooltips.GIVES_BUFFS.build());
            tooltip.addAll(this.tier.getTooltip());
        } else {
            tooltip.add((ITextComponent)Tooltips.HOLD_SHIFT_FOR_INFO.build());
        }
    }

    public static enum EssenceAppleTier {
        INFERIUM(6, 0.3f, Effects.field_76444_x),
        PRUDENTIUM(8, 0.4f, Effects.field_76444_x, Effects.field_76424_c),
        TERTIUM(10, 0.5f, Effects.field_76444_x, Effects.field_76424_c, Effects.field_76429_m),
        IMPERIUM(12, 0.6f, Effects.field_76444_x, Effects.field_76424_c, Effects.field_76429_m, Effects.field_76428_l),
        SUPREMIUM(16, 0.7f, Effects.field_76444_x, Effects.field_76424_c, Effects.field_76429_m, Effects.field_76428_l, Effects.field_76420_g),
        INSANIUM(20, 0.8f, Effects.field_76444_x, Effects.field_76424_c, Effects.field_76429_m, Effects.field_76428_l, Effects.field_76420_g, Effects.field_76422_e);

        private final Consumer<LivingEntity> onFoodEaten;
        private final List<ITextComponent> tooltip;
        private final int hunger;
        private final float saturation;
        private final Effect[] effects;

        private EssenceAppleTier(int hunger, float saturation, Effect ... effects) {
            this.hunger = hunger;
            this.saturation = saturation;
            this.effects = effects;
            this.onFoodEaten = entity -> Arrays.stream(effects).forEach(e -> EssenceAppleTier.addPotionEffect(entity, e));
            this.tooltip = new ArrayList<ITextComponent>();
        }

        public void onFoodEaten(LivingEntity entity) {
            this.onFoodEaten.accept(entity);
        }

        public List<ITextComponent> getTooltip() {
            if (this.tooltip.isEmpty()) {
                Arrays.stream(this.effects).forEach(e -> {
                    StringTextComponent buff = new StringTextComponent(e.func_199286_c().getString() + " II");
                    int buffDuration = (Integer)ModConfigs.ESSENCE_APPLE_DURATION.get();
                    int minutes = Math.floorDiv(buffDuration, 60);
                    String seconds = String.format("%02d", buffDuration % 60);
                    StringTextComponent duration = new StringTextComponent(minutes + ":" + seconds);
                    this.tooltip.add((ITextComponent)ModTooltips.BUFF_LINE.args(new Object[]{buff, duration}).build());
                });
            }
            return this.tooltip;
        }

        private static void addPotionEffect(LivingEntity entity, Effect effect) {
            int effectDuration = (Integer)ModConfigs.ESSENCE_APPLE_DURATION.get() * 20;
            EffectInstance current = entity.func_70660_b(effect);
            int duration = current != null ? current.func_76459_b() : 0;
            entity.func_195064_c(new EffectInstance(effect, duration + effectDuration, 1));
        }
    }
}

