/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.block;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import team.chisel.api.block.ICarvable;
import team.chisel.api.block.VariationData;

@ParametersAreNonnullByDefault
public class BlockCarvable
extends Block
implements ICarvable {
    private final VariationData variation;
    private boolean dragonProof = false;

    public BlockCarvable(AbstractBlock.Properties properties, VariationData variation) {
        super(properties);
        this.variation = variation;
    }

    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return super.func_200122_a(state, adjacentBlockState, side) && state != adjacentBlockState;
    }

    public Block setDragonProof() {
        this.dragonProof = true;
        return this;
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        if (entity instanceof EnderDragonEntity) {
            return !this.dragonProof;
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public String func_149739_a() {
        return this.variation.getGroup().getTranslationKey();
    }

    @Override
    public VariationData getVariation() {
        return this.variation;
    }
}

