/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.integration.jei;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import team.chisel.api.carving.ICarvingGroup;
import team.chisel.client.util.ChiselLangKeys;
import team.chisel.common.init.ChiselItems;

@ParametersAreNonnullByDefault
public class ChiselRecipeCategory
implements IRecipeCategory<ICarvingGroup> {
    private static final ResourceLocation TEXTURE_LOC = new ResourceLocation("chisel", "textures/chiseljei.png");
    private final IDrawable icon;
    private final IDrawable background;
    private final IDrawable arrowUp;
    private final IDrawable arrowDown;
    @Nullable
    private IRecipeLayout layout;
    @Nullable
    private IFocus<?> focus;

    public ChiselRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ChiselItems.IRON_CHISEL.get()));
        this.background = guiHelper.createDrawable(TEXTURE_LOC, 0, 0, 165, 126);
        this.arrowDown = guiHelper.createDrawable(TEXTURE_LOC, 166, 0, 18, 15);
        this.arrowUp = guiHelper.createDrawable(TEXTURE_LOC, 166, 15, 18, 15);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return new ResourceLocation("chisel", "chiseling");
    }

    @Nonnull
    public String getTitle() {
        return ChiselLangKeys.JEI_TITLE.getComponent().getString();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void draw(ICarvingGroup recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        if (this.layout != null) {
            if (this.focus == null || this.focus.getMode() == IFocus.Mode.INPUT) {
                this.arrowDown.draw(matrixStack, 73, 21);
            } else {
                this.arrowUp.draw(matrixStack, 73, 21);
            }
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, ICarvingGroup recipeWrapper, IIngredients ingredients) {
        int i;
        this.layout = recipeLayout;
        IFocus focus = this.focus = recipeLayout.getFocus();
        recipeLayout.getItemStacks().init(0, focus == null || focus.getMode() == IFocus.Mode.INPUT, 73, 3);
        if (focus != null) {
            recipeLayout.getItemStacks().set(0, (ItemStack)focus.getValue());
        } else {
            recipeLayout.getItemStacks().set(0, ingredients.getInputs(VanillaTypes.ITEM).stream().flatMap(l -> l.stream()).collect(Collectors.toList()));
        }
        int rowWidth = 9;
        int xStart = 2;
        int yStart = 36;
        int outputs = ingredients.getOutputs(VanillaTypes.ITEM).size();
        int MAX_SLOTS = 45;
        ArrayList stacks = Lists.newArrayList();
        for (i = 0; i < outputs; ++i) {
            int slot = i % MAX_SLOTS;
            if (stacks.size() <= slot) {
                stacks.add(Lists.newArrayList());
            }
            ItemStack stack = (ItemStack)((List)ingredients.getOutputs(VanillaTypes.ITEM).get(i)).get(0);
            ((List)stacks.get(slot)).add(stack.func_77946_l());
        }
        if (outputs > MAX_SLOTS) {
            int leftover;
            for (int i2 = leftover = outputs % MAX_SLOTS; i2 < MAX_SLOTS; ++i2) {
                ((List)stacks.get(i2)).add(ItemStack.field_190927_a);
            }
        }
        for (i = 0; i < stacks.size(); ++i) {
            int x = xStart + i % rowWidth * 18;
            int y = yStart + i / rowWidth * 18;
            recipeLayout.getItemStacks().init(i + 1, focus != null && focus.getMode() == IFocus.Mode.OUTPUT, x, y);
            recipeLayout.getItemStacks().set(i + 1, (List)stacks.get(i));
        }
    }

    public Class<? extends ICarvingGroup> getRecipeClass() {
        return ICarvingGroup.class;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(ICarvingGroup group, IIngredients ingredients) {
        List variants = group.getItemTag().func_230236_b_().stream().map(ItemStack::new).collect(Collectors.toList());
        ingredients.setInputs(VanillaTypes.ITEM, variants);
        ingredients.setOutputs(VanillaTypes.ITEM, variants);
    }
}

