/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.inventory;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import team.chisel.api.carving.ICarvingGroup;
import team.chisel.common.inventory.ChiselContainer;
import team.chisel.common.inventory.InventoryChiselSelection;
import team.chisel.common.inventory.SlotChiselInput;
import team.chisel.common.inventory.SlotChiselSelection;
import team.chisel.common.util.NBTUtil;

@ParametersAreNonnullByDefault
public class ContainerChiselHitech
extends ChiselContainer {
    @Nullable
    private Slot selection;
    @Nullable
    private Slot target;
    private List<Slot> selectionDuplicates = ImmutableList.of();
    @Nullable
    private ICarvingGroup currentGroup;

    public ContainerChiselHitech(ContainerType<? extends ChiselContainer> type, int windowId, PlayerInventory inventoryplayer) {
        this(type, windowId, inventoryplayer, new InventoryChiselSelection(ItemStack.field_190927_a, 63), Hand.MAIN_HAND);
    }

    public ContainerChiselHitech(ContainerType<? extends ChiselContainer> type, int windowId, PlayerInventory inventoryplayer, InventoryChiselSelection inv, Hand hand) {
        super(type, windowId, inventoryplayer, inv, hand);
        int targetSlot;
        int selectionSlot = NBTUtil.getHitechSelection(this.chisel);
        if (selectionSlot >= inv.func_70302_i_()) {
            this.setSelection(this.func_75139_a(selectionSlot));
        }
        if ((targetSlot = NBTUtil.getHitechTarget(this.chisel)) >= 0 && targetSlot < inv.func_70302_i_() - 1) {
            this.setTarget(this.func_75139_a(targetSlot));
        }
    }

    public void setTarget(@Nullable Slot slot) {
        this.target = slot;
        NBTUtil.setHitechTarget(this.chisel, (Integer)Optional.fromNullable((Object)this.getTarget()).transform(s -> s.field_75222_d).or((Object)-1));
    }

    public void setSelection(@Nullable Slot slot) {
        this.selection = slot;
        if (slot == null || !slot.func_75216_d()) {
            this.currentGroup = null;
            this.selectionDuplicates = ImmutableList.of();
            this.setTarget(null);
        } else {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = this.getInventoryChisel().size + 1; i < this.field_75151_b.size(); ++i) {
                Slot s2 = this.func_75139_a(i);
                if (slot == s2 || !ItemStack.func_179545_c((ItemStack)slot.func_75211_c(), (ItemStack)s2.func_75211_c())) continue;
                builder.add((Object)s2);
            }
            this.selectionDuplicates = builder.build();
            ICarvingGroup group = this.carving.getGroup(slot.func_75211_c().func_77973_b()).orElse(null);
            if (this.currentGroup != null && group != this.currentGroup) {
                this.setTarget(null);
            }
            this.currentGroup = group;
        }
        ItemStack stack = slot == null ? ItemStack.field_190927_a : slot.func_75211_c();
        this.getInventoryChisel().setStackInSpecialSlot(stack);
        this.getInventoryChisel().updateItems();
        NBTUtil.setHitechSelection(this.chisel, (Integer)Optional.fromNullable((Object)this.getSelection()).transform(s -> s.field_75222_d).or((Object)-1));
    }

    @Nullable
    public ItemStack getSelectionStack() {
        Slot slot = this.getSelection();
        return slot == null ? ItemStack.field_190927_a : slot.func_75211_c();
    }

    public ItemStack getTargetStack() {
        Slot slot = this.getTarget();
        return slot == null ? ItemStack.field_190927_a : slot.func_75211_c();
    }

    @Override
    protected void addSlots() {
        int i;
        int top = 8;
        int left = 88;
        for (i = 0; i < this.getInventoryChisel().size; ++i) {
            this.func_75146_a(new SlotChiselSelection(this, this.inventoryChisel, this.inventoryChisel, i, left + i % 9 * 18, top + i / 9 * 18));
        }
        this.inputSlot = new SlotChiselInput(this, this.inventoryChisel, this.getInventoryChisel().size, -1000, 0);
        this.func_75146_a(this.inputSlot);
        top += 130;
        for (i = 0; i < 27; ++i) {
            this.func_75146_a(new Slot((IInventory)this.inventoryPlayer, i + 9, left + i % 9 * 18, top + i / 9 * 18));
        }
        top += 58;
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)this.inventoryPlayer, i, left + i % 9 * 18, top + i / 9 * 18));
        }
    }

    @Override
    public void func_75134_a(PlayerEntity entityplayer) {
        NBTUtil.setChiselTarget(this.getChisel(), this.getTargetStack());
        super.func_75134_a(entityplayer);
    }

    @Override
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        if (slotId >= 0) {
            Slot slot = this.func_75139_a(slotId);
            if (slotId < this.getInventoryChisel().size) {
                this.setTarget(slot);
            } else if (dragType == 1) {
                ItemStack toFind = slot.func_75211_c();
                if (!toFind.func_190926_b()) {
                    for (int i = 0; i < this.getInventoryChisel().size; ++i) {
                        if (!ItemStack.func_179545_c((ItemStack)toFind, (ItemStack)this.getInventoryChisel().func_70301_a(i))) continue;
                        this.setTarget(this.func_75139_a(i));
                    }
                }
            } else {
                this.setSelection(slot);
            }
        }
        return ItemStack.field_190927_a;
    }

    @Nullable
    public Slot getSelection() {
        return this.selection;
    }

    @Nullable
    public Slot getTarget() {
        return this.target;
    }

    public List<Slot> getSelectionDuplicates() {
        return this.selectionDuplicates;
    }

    @Nullable
    public ICarvingGroup getCurrentGroup() {
        return this.currentGroup;
    }

    public void setSelectionDuplicates(List<Slot> selectionDuplicates) {
        this.selectionDuplicates = selectionDuplicates;
    }

    public void setCurrentGroup(@Nullable ICarvingGroup currentGroup) {
        this.currentGroup = currentGroup;
    }
}

