/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.item;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import team.chisel.Chisel;
import team.chisel.api.IChiselItem;
import team.chisel.api.block.ICarvable;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.api.carving.ICarvingGroup;
import team.chisel.api.carving.ICarvingVariation;
import team.chisel.api.carving.IChiselMode;
import team.chisel.api.carving.IVariationRegistry;
import team.chisel.common.util.NBTUtil;
import team.chisel.common.util.SoundUtil;

@ParametersAreNonnullByDefault
public class ChiselController {
    private static final LoadingCache<PlayerEntity, Long> HACKY_CACHE = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).weakKeys().build((CacheLoader)new CacheLoader<PlayerEntity, Long>(){

        public Long load(PlayerEntity key) throws Exception {
            return 0L;
        }
    });
    private static final MethodHandle _updateFacingWithBoundingBox;

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.LeftClickBlock event) {
        PlayerEntity player = event.getPlayer();
        ItemStack held = event.getItemStack();
        if (held.func_77973_b() instanceof IChiselItem) {
            ICarvingGroup blockGroup;
            ItemStack target = NBTUtil.getChiselTarget(held);
            IChiselItem chisel = (IChiselItem)held.func_77973_b();
            IVariationRegistry registry = CarvingUtils.getChiselRegistry();
            BlockState state = event.getWorld().func_180495_p(event.getPos());
            if (!chisel.canChiselBlock(event.getWorld(), player, event.getHand(), event.getPos(), state)) {
                return;
            }
            ICarvingGroup iCarvingGroup = blockGroup = state.func_177230_c() instanceof ICarvable ? ((ICarvable)state.func_177230_c()).getVariation().getGroup() : (ICarvingGroup)registry.getGroup(state.func_177230_c()).orElse(null);
            if (blockGroup == null) {
                return;
            }
            IChiselMode mode = NBTUtil.getChiselMode(held);
            Iterable<? extends BlockPos> candidates = mode.getCandidates(player, event.getPos(), event.getFace());
            if (!target.func_190926_b()) {
                ICarvingGroup sourceGroup = registry.getGroup(target.func_77973_b()).orElse(null);
                if (blockGroup == sourceGroup) {
                    ICarvingVariation variation = registry.getVariation(target.func_77973_b()).orElse(null);
                    if (variation != null) {
                        if (variation.getBlock() != null) {
                            ChiselController.setAll(candidates, player, state, variation);
                        }
                    } else {
                        Chisel.logger.warn("Found itemstack {} in group {}, but it has no variation!", (Object)target, (Object)sourceGroup.getId());
                    }
                }
            } else {
                List<Object> variations = new ArrayList(blockGroup.getBlockTag().map(ITag::func_230236_b_).orElse(Collections.emptyList()));
                variations = variations.stream().filter(v -> v.getBlock() != null).collect(Collectors.toList());
                int index = variations.indexOf(state.func_177230_c());
                index = player.func_225608_bj_() ? index - 1 : index + 1;
                index = (index + variations.size()) % variations.size();
                ICarvingVariation next = registry.getVariation((Block)variations.get(index)).orElse(null);
                ChiselController.setAll(candidates, player, state, next);
            }
        }
    }

    private static void setAll(Iterable<? extends BlockPos> candidates, PlayerEntity player, BlockState origState, ICarvingVariation v) {
        if (!ChiselController.checkHackyCache(player)) {
            return;
        }
        for (BlockPos blockPos : candidates) {
            ChiselController.setVariation(player, blockPos, origState, v);
        }
    }

    private static boolean checkHackyCache(PlayerEntity player) {
        long time = player.func_130014_f_().func_82737_E();
        if ((Long)HACKY_CACHE.getUnchecked((Object)player) > time - 2L) {
            return false;
        }
        HACKY_CACHE.put((Object)player, (Object)time);
        return true;
    }

    private static void setVariation(PlayerEntity player, BlockPos pos, BlockState origState, ICarvingVariation v) {
        Block targetBlock = v.getBlock();
        Preconditions.checkNotNull((Object)targetBlock, (Object)"Variation state cannot be null!");
        World world = player.field_70170_p;
        BlockState curState = world.func_180495_p(pos);
        ItemStack held = player.func_184614_ca();
        if (curState.func_177230_c() == v.getBlock()) {
            return;
        }
        if (origState != curState) {
            return;
        }
        if (held.func_77973_b() instanceof IChiselItem) {
            IChiselItem chisel = (IChiselItem)held.func_77973_b();
            ItemStack current = CarvingUtils.getChiselRegistry().getVariation(curState.func_177230_c()).map(ICarvingVariation::getItem).map(ItemStack::new).orElse(null);
            current.func_190920_e(1);
            ItemStack target = new ItemStack((IItemProvider)v.getItem());
            target.func_190920_e(1);
            chisel.craftItem(held, current, target, player, p -> p.func_213361_c(EquipmentSlotType.MAINHAND));
            chisel.onChisel(player.field_70170_p, player, held, v);
            if (held.func_190916_E() <= 0) {
                ItemStack targetStack = NBTUtil.getChiselTarget(held);
                player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)targetStack);
            }
            if (world.field_72995_K) {
                SoundUtil.playSound(player, held, targetBlock);
                world.func_217378_a(player, 2001, pos, Block.func_196246_j((BlockState)origState));
            }
            world.func_175656_a(pos, targetBlock.func_176223_P());
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        IChiselItem chisel;
        ItemStack stack;
        if (!event.getWorld().field_72995_K && (stack = event.getItemStack()).func_77973_b() instanceof IChiselItem && (chisel = (IChiselItem)stack.func_77973_b()).canOpenGui(event.getWorld(), event.getPlayer(), event.getHand())) {
            event.getPlayer().func_213829_a(chisel.getGuiType(event.getWorld(), event.getPlayer(), event.getHand()).provide(stack, event.getHand()));
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack mainhandStack;
        if (event.getHand() == Hand.OFF_HAND && (mainhandStack = event.getPlayer().func_184614_ca()).func_77973_b() instanceof IChiselItem) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLeftClickEntity(AttackEntityEvent event) {
        ItemStack held;
        if (event.getTarget() instanceof PaintingEntity && (held = event.getPlayer().func_184614_ca()).func_77973_b() instanceof IChiselItem) {
            PaintingEntity painting = (PaintingEntity)event.getTarget();
            ArrayList values = new ArrayList(ForgeRegistries.PAINTING_TYPES.getValues());
            do {
                painting.field_70522_e = (PaintingType)values.get((values.indexOf(painting.field_70522_e) + (event.getPlayer().func_225608_bj_() ? -1 : 1) + values.size()) % values.size());
                try {
                    _updateFacingWithBoundingBox.invokeExact((HangingEntity)painting, painting.func_174811_aO());
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            } while (!painting.func_70518_d());
            ChiselController.damageItem(held, event.getPlayer());
            event.getPlayer().field_70170_p.func_184133_a(event.getPlayer(), event.getTarget().func_233580_cy_(), SoundEvents.field_187694_dK, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            event.setCanceled(true);
        }
    }

    private static void damageItem(ItemStack stack, PlayerEntity player) {
        stack.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(Hand.MAIN_HAND));
        if (stack.func_190916_E() <= 0) {
            player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
            ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)stack, (Hand)Hand.MAIN_HAND);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        ItemStack stack = event.getPlayer().func_184614_ca();
        if (event.getPlayer().field_71075_bZ.field_75098_d && !stack.func_190926_b() && stack.func_77973_b() instanceof IChiselItem) {
            event.setCanceled(true);
        }
    }

    static {
        try {
            _updateFacingWithBoundingBox = MethodHandles.lookup().unreflect(ObfuscationReflectionHelper.findMethod(HangingEntity.class, (String)"func_174859_a", (Class[])new Class[]{Direction.class}));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

