/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.item;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import team.chisel.api.chunkdata.IOffsetData;
import team.chisel.client.util.ClientUtil;
import team.chisel.common.util.NBTSaveable;
import team.chisel.common.util.PerChunkData;

@ParametersAreNonnullByDefault
public class ItemOffsetTool
extends Item {
    public static final String DATA_KEY = "offsettool";

    public ItemOffsetTool(Item.Properties properties) {
        super(properties);
        PerChunkData.INSTANCE.registerChunkData(DATA_KEY, new PerChunkData.ChunkDataBase<OffsetData>(OffsetData.class, true));
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> MinecraftForge.EVENT_BUS.addListener(this::onBlockHighlight));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockState state = world.func_180495_p(context.func_195995_a());
        if (world.field_72995_K) {
            return this.canOffset(context.func_195991_k(), context.func_195995_a(), context.func_195996_i()) ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        PerChunkData.ChunkDataBase cd = (PerChunkData.ChunkDataBase)PerChunkData.INSTANCE.getData(DATA_KEY);
        OffsetData data = (OffsetData)cd.getDataForChunk(world.func_234923_W_(), world.func_217349_x(context.func_195995_a()).func_76632_l());
        Vector3d hitVec = context.func_221532_j();
        data.move(this.getMoveDir(context.func_196000_l(), hitVec));
        PerChunkData.INSTANCE.chunkModified((Chunk)world.func_217349_x(context.func_195995_a()), DATA_KEY);
        return super.func_195939_a(context);
    }

    public Direction getMoveDir(Direction face, Vector3d hitVec) {
        HashMap map = Maps.newHashMap();
        if (face.func_82601_c() != 0) {
            this.fillMap(map, hitVec.field_72449_c, hitVec.field_72448_b, Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH);
        } else if (face.func_96559_d() != 0) {
            this.fillMap(map, hitVec.field_72450_a, hitVec.field_72449_c, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST);
        } else if (face.func_82599_e() != 0) {
            this.fillMap(map, hitVec.field_72450_a, hitVec.field_72448_b, Direction.DOWN, Direction.UP, Direction.WEST, Direction.EAST);
        }
        ArrayList keys = Lists.newArrayList(map.keySet());
        Collections.sort(keys);
        return (Direction)map.get(keys.get(0));
    }

    private void fillMap(Map<Double, Direction> map, double x, double y, Direction ... dirs) {
        map.put(Line2D.ptLineDistSq(0.0, 0.0, 1.0, 0.0, x, y), dirs[0]);
        map.put(Line2D.ptLineDistSq(0.0, 1.0, 1.0, 1.0, x, y), dirs[1]);
        map.put(Line2D.ptLineDistSq(0.0, 0.0, 0.0, 1.0, x, y), dirs[2]);
        map.put(Line2D.ptLineDistSq(1.0, 0.0, 1.0, 1.0, x, y), dirs[3]);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onBlockHighlight(DrawHighlightEvent.HighlightBlock event) {
        BlockRayTraceResult target = event.getTarget();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (this.canOffset(player.field_70170_p, target.func_216350_a(), player.func_184614_ca()) || this.canOffset(player.field_70170_p, target.func_216350_a(), player.func_184592_cb())) {
            Direction face = target.func_216354_b();
            BlockPos pos = target.func_216350_a();
            MatrixStack ms = event.getMatrix();
            ms.func_227860_a_();
            RenderSystem.disableLighting();
            RenderSystem.disableTexture();
            RenderSystem.depthMask((boolean)false);
            IVertexBuilder linesBuf = event.getBuffers().getBuffer(RenderType.func_228659_m_());
            float x = Math.max(0, face.func_82601_c());
            float y = Math.max(0, face.func_96559_d());
            float z = Math.max(0, face.func_82599_e());
            Vector3d viewport = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
            ms.func_227861_a_(-viewport.field_72450_a, -viewport.field_72448_b, -viewport.field_72449_c);
            ms.func_227861_a_((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            Matrix4f mat = ms.func_227866_c_().func_227870_a_();
            if (face.func_82601_c() != 0) {
                linesBuf.func_227888_a_(mat, x, 0.0f, 0.0f).func_227885_a_(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                linesBuf.func_227888_a_(mat, x, 1.0f, 1.0f).func_227885_a_(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                linesBuf.func_227888_a_(mat, x, 1.0f, 0.0f).func_227885_a_(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                linesBuf.func_227888_a_(mat, x, 0.0f, 1.0f).func_227885_a_(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
            } else if (face.func_96559_d() != 0) {
                linesBuf.func_227888_a_(mat, 0.0f, y, 0.0f).func_227885_a_(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                linesBuf.func_227888_a_(mat, 1.0f, y, 1.0f).func_227885_a_(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                linesBuf.func_227888_a_(mat, 1.0f, y, 0.0f).func_227885_a_(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                linesBuf.func_227888_a_(mat, 0.0f, y, 1.0f).func_227885_a_(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
            } else {
                linesBuf.func_227888_a_(mat, 0.0f, 0.0f, z).func_227885_a_(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                linesBuf.func_227888_a_(mat, 1.0f, 1.0f, z).func_227885_a_(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                linesBuf.func_227888_a_(mat, 1.0f, 0.0f, z).func_227885_a_(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                linesBuf.func_227888_a_(mat, 0.0f, 1.0f, z).func_227885_a_(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
            }
            Vector3d hit = target.func_216347_e();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.enablePolygonOffset();
            RenderSystem.polygonOffset((float)-1.0f, (float)-10.0f);
            RenderSystem.disableCull();
            IVertexBuilder buf = event.getBuffers().getBuffer(ClientUtil.OFFSET_OVERLAY);
            Direction moveDir = this.getMoveDir(face, hit.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
            int clampedX = Math.max(0, moveDir.func_82601_c());
            int clampedY = Math.max(0, moveDir.func_96559_d());
            int clampedZ = Math.max(0, moveDir.func_82599_e());
            boolean isX = moveDir.func_82601_c() != 0;
            boolean isY = moveDir.func_96559_d() != 0;
            boolean isZ = moveDir.func_82599_e() != 0;
            float alpha = 0.33333334f;
            if (face.func_82601_c() != 0) {
                buf.func_227888_a_(mat, x, 0.5f, 0.5f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                buf.func_227888_a_(mat, x, isY ? (float)clampedY : 0.0f, isZ ? (float)clampedZ : 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                buf.func_227888_a_(mat, x, isY ? (float)clampedY : 1.0f, isZ ? (float)clampedZ : 1.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
            } else if (face.func_96559_d() != 0) {
                buf.func_227888_a_(mat, 0.5f, y, 0.5f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                buf.func_227888_a_(mat, isX ? (float)clampedX : 0.0f, y, isZ ? (float)clampedZ : 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                buf.func_227888_a_(mat, isX ? (float)clampedX : 1.0f, y, isZ ? (float)clampedZ : 1.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
            } else {
                buf.func_227888_a_(mat, 0.5f, 0.5f, z).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                buf.func_227888_a_(mat, isX ? (float)clampedX : 0.0f, isY ? (float)clampedY : 0.0f, z).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                buf.func_227888_a_(mat, isX ? (float)clampedX : 1.0f, isY ? (float)clampedY : 1.0f, z).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
            }
            ((IRenderTypeBuffer.Impl)event.getBuffers()).func_228462_a_(ClientUtil.OFFSET_OVERLAY);
            RenderSystem.disablePolygonOffset();
            RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
            ms.func_227865_b_();
        }
    }

    private boolean canOffset(World world, BlockPos pos, ItemStack stack) {
        BlockState state = world.func_180495_p(pos);
        if (stack.func_190926_b() || stack.func_77973_b() != this) {
            return false;
        }
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
        return true;
    }

    public static class OffsetData
    implements NBTSaveable,
    IOffsetData {
        private BlockPos offset = BlockPos.field_177992_a;

        @Override
        public void write(CompoundNBT tag) {
            tag.func_74777_a("offset", (short)(this.offset.func_177958_n() << 8 | this.offset.func_177956_o() << 4 | this.offset.func_177952_p()));
        }

        @Override
        public void read(CompoundNBT tag) {
            short data = tag.func_74765_d("offset");
            this.offset = new BlockPos(data >> 8 & 0xF, data >> 4 & 0xF, data & 0xF);
        }

        void move(Direction dir) {
            this.offset = this.wrap(this.offset.func_177972_a(dir.func_176734_d()));
        }

        @Override
        @Nonnull
        public BlockPos getOffset() {
            return this.offset;
        }

        private int positiveModulo(int num, int denom) {
            return (num + denom) % denom;
        }

        private BlockPos wrap(BlockPos pos) {
            return new BlockPos(this.positiveModulo(pos.func_177958_n(), 16), this.positiveModulo(pos.func_177956_o(), 16), this.positiveModulo(pos.func_177952_p(), 16));
        }

        public String toString() {
            return "ItemOffsetTool.OffsetData(offset=" + this.getOffset() + ")";
        }
    }
}

