/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.util;

import java.util.Comparator;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class ItemSorter {
    public static <T extends IItemProvider> Comparator<T> byName(Comparator<ResourceLocation> child) {
        return Comparator.comparing(i -> i.func_199767_j().getRegistryName(), child);
    }

    public static <T extends IItemProvider> Comparator<T> alphabetic() {
        return ItemSorter.byName(ItemSorter.alphabeticByName());
    }

    private static Comparator<ResourceLocation> alphabeticByName() {
        return Comparator.comparing(r -> r.func_110624_b()).thenComparing(r -> r.func_110623_a());
    }

    public static <T extends IItemProvider> Comparator<T> alphabeticVanillaFirst() {
        return ItemSorter.vanillaFirst().thenComparing(ItemSorter.byName(ItemSorter.alphabeticByName()));
    }

    public static <T extends IItemProvider> Comparator<T> variantOrder() {
        return ItemSorter.vanillaFirst().thenComparing(ItemSorter.byName(ItemSorter.rawFirst().thenComparing(ItemSorter.alphabeticByName())));
    }

    private static <T extends IItemProvider> Comparator<T> vanillaFirst() {
        return (i1, i2) -> {
            String n1 = i1.func_199767_j().getRegistryName().func_110624_b();
            String n2 = i2.func_199767_j().getRegistryName().func_110624_b();
            if (n1.equals("minecraft") && n2.equals("minecraft")) {
                return Integer.compare(Item.func_150891_b((Item)i1.func_199767_j()), Item.func_150891_b((Item)i2.func_199767_j()));
            }
            return n1.equals("minecraft") ? -1 : (n2.equals("minecraft") ? 1 : 0);
        };
    }

    private static Comparator<ResourceLocation> rawFirst() {
        return Comparator.comparing(r -> r.func_110623_a(), (n1, n2) -> n1.endsWith("/raw") && n2.endsWith("/raw") ? 0 : (n1.endsWith("/raw") ? -1 : (n2.endsWith("/raw") ? 1 : 0)));
    }
}

