/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.industrialagriculture.mekanism;

import com.blakebr0.mysticalagriculture.api.crop.CropTextures;
import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.github.elrol.industrialagriculture.init.ColorInit;
import com.github.elrol.industrialagriculture.init.CropInit;
import com.github.elrol.industrialagriculture.init.CruxInit;
import com.github.elrol.industrialagriculture.libs.RL;
import com.github.elrol.industrialagriculture.mekanism.config.Config;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="iapmekanism")
public class IAP_Mekanism {
    public static final Logger LOGGER = LogManager.getLogger();
    public static Config config;
    private CropTextures ingot = new CropTextures(CropTextures.FLOWER_INGOT_BLANK, CropTextures.ESSENCE_INGOT_BLANK, CropTextures.SEED_BLANK);

    public IAP_Mekanism() {
        config = Config.load();
        this.colorInit();
        this.soulInit();
        this.cropInit();
    }

    private void colorInit() {
        ColorInit.addColor((String)"sulfur", (int)14998698);
    }

    private void soulInit() {
    }

    private void cropInit() {
        CruxInit.addCruxBlocks(config.getCruxMap());
        this.initCrop("bronze", "mekanism:ingot_bronze");
        this.initCrop("copper", "mekanism:ingot_copper");
        this.initCrop("osmium", "mekanism:ingot_osmium");
        this.initCrop("refined_glowstone", "mekanism:ingot_refined_glowstone");
        this.initCrop("refined_obsidian", "mekanism:ingot_refined_obsidian");
        this.initCrop("salt", "mekanism:salt");
        this.initCrop("steel", "mekanism:ingot_steel");
        this.initCrop("tin", "mekanism:ingot_tin");
        this.initCrop("sulfur", "mekanism:dust_sulfur");
    }

    private void initCrop(String name, String item, CropTextures textures) {
        CropInit.addItemResourceCrop((String)name, (CropTier)config.getCropTier(name), (String)item, (CropTextures)textures);
    }

    private void initCrop(String name) {
        CropInit.addTagResourceCrop((String)name, (CropTier)config.getCropTier(name), (String)("forge:ingots/" + name), (CropTextures)this.ingot);
    }

    private void initCrop(String name, CropTextures textures) {
        CropInit.addTagResourceCrop((String)name, (CropTier)config.getCropTier(name), (String)("forge:ingots/" + name), (CropTextures)textures);
    }

    private void initCrop(String name, String item) {
        CropTextures texture = new CropTextures((ResourceLocation)new RL("iapmekanism", "block/" + name + "_flower"), (ResourceLocation)new RL("iapmekanism", "item/" + name + "_essence"), (ResourceLocation)new RL("iapmekanism", "item/" + name + "_seeds"));
        this.initCrop(name, item, texture);
    }

    private void initTagCrop(String name, String tag) {
        CropInit.addTagResourceCrop((String)name, (CropTier)config.getCropTier(name), (String)tag, (CropTextures)this.ingot);
    }
}

